{include file="mheader.tpl"}


<form method=post>
<input type=hidden name=a value="security">
<input type=hidden name=action value="save">
<h2 class="user-panel-title">Detect IP Address Change Sensitivity</h2>
<input type=radio name=ip value=disabled {if $security.detect_ip == 'disabled'}checked{/if}>Disabled<br>
<input type=radio name=ip value=medium {if $security.detect_ip == 'medium'}checked{/if}>Medium<br>
<input type=radio name=ip value=high {if $security.detect_ip == 'high'}checked{/if}>High<br>
<input type=radio name=ip value=always {if $security.detect_ip == 'always'}checked{/if}>Paranoic<br><br>

<h2 class="user-panel-title">Detect Browser Change</h2>
<input type=radio name=browser value=disabled {if $security.detect_browser == 'disabled'}checked{/if}>Disabled<br>
<input type=radio name=browser value=enabled {if $security.detect_browser == 'enabled'}checked{/if}>Enabled<br><br>
<input type=submit value="Set" class="btn btn-primary">
</form>

<h2 class="user-panel-title">Two Factor Authentication</h2>
<p>Two-factor authentication is a method for extra protection of your account. When it is activated you need to enter not only your password, but also a special code received by your mobile app.</p>




<form method=post name=mainform>
<input type=hidden name=a value="security">
<input type=hidden name=action value="tfa_save">
<input type=hidden name=time>

{if $errors.invalid_tfa_code}
<b style=color:red>Invalid code.</b><br>
{/if}
{if $errors.invalid_tfa_secret}
<b style=color:red>Invalid Secret.</b><br>
{/if}



<div class="gaps-2x"></div>
 
<div class="d-flex guttar-20px">
   <div><span>Current Status:</span></div>
   <div><span class="alert alert-xs alert-dark">{if $tfa_enabled}Enabled{else}Disabled{/if}</span></div>
</div>
 



<div class="steps">

<div class="from-step-heading"></div>

{if $tfa_enabled}
<input type="checkbox" name="tfa_on_login" value=1 {if $tfa_settings.login}checked{/if}> on Login<br>
<input type="checkbox" name="tfa_on_edit_account" value=1 {if $tfa_settings.edit_account}checked{/if}> on Edit Account<br>
<input type="checkbox" name="tfa_on_withdraw" value=1 {if $tfa_settings.withdraw}checked{/if}> on Withdraw<br>
<input type="checkbox" name="tfa_disable" value=1> <b style=color:red>Disable Two Factor Authentication (not recommended)</b><br>
<br>
Confirm by typing code: <input type=text name="code" class=inpts> <input type=submit value="Update" class="btn btn-primary">
{else}

<div class="from-step-item">
<div class="from-step-heading">
  <div class="from-step-number">01</div>
    <div class="from-step-head">
     <h4>Step 1 : Install Google Authenticator</h4>
      <p>Download and Install Google Authenticator on your mobile device.</p>
    </div>
  </div>
  <div class="from-step-content">
  <ul class="ath-content-sublist">
    <li><a href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en_GB" targe=_blank>Google Authenticator for Android</a></li>
    <li><a href="https://apps.apple.com/gb/app/google-authenticator/id388497605" targe=_blank>Google Authenticator for IOS</a></li>
  </ul>
  </div>
</div>

<div class="from-step-item">
 <div class="from-step-heading">
  <div class="from-step-number">02</div>
    <div class="from-step-head">
     <h4>Step 2 : Scan the QR code in Google Authenticator</h4>
      <p>Your Secret Code is: <b>{$tfa_secret}</b> <input type=hidden name="tfa_secret" value="{$tfa_secret}"></p>
    </div>
  </div>
  <div class="from-step-content" style="text-align:center;"><img src="{$tfa_secret_url}" class="ath-content-qrimg"></div>
</div>

<div class="from-step-heading">
    <div class="from-step-number">03</div>
      <div class="from-step-head">
       <h4>Step 3 : Enter 2FA Code</h4>
        <p>Enter the numeric code that is displayed in Google Authenticator</p>
      </div>
    </div>
<div class="from-step-content">
<div class="input-item input-with-label">
  <i class="ti ti-lock"></i>  
  <input class="input-bordered" type="text" name="code" placeholder="2FA Code">
</div><!-- .input-item -->
<button type=submit class="btn btn-primary">Enable</button>
</div>
{/if}


</div>

</form>


{literal}
<script language=javascript>
document.mainform.time.value = (new Date()).getTime();

function checkform() {
  if (!document.mainform.code.value.match(/^[0-9]{6}$/)) {
    alert("Please type code!");
    document.mainform.code.focus();
    return false;
  }
  return true;
}
</script>
{/literal}

 
 {include file="mfooter.tpl"}