<?php

# Ensure that this file is being accessed validly

defined( 'COURIER_DIR' ) OR DIE;

# Create The Courier Instance

class Courier {
	
	/**
	 * Project Directories
	 */
	public static $ADMIN_DIR = COURIER_DIR . "/sys-admin";
	public static $CLIENT_DIR = COURIER_DIR . "/sys-client";
	public static $HOME_DIR = COURIER_DIR . "/sys-home";
	
	public static $adminFocus = UADMIN_ROUTE . "/cargo";
	public static $clientFocus = UDASH_ROUTE . "/cargo";
	
	public static $prefix = DB_TABLE_PREFIX; // Pairs Instance
	public static $orderMeta; // Pairs Instance
	
	/**
	 * Project Variables
	 */
	public static $currency;
	
	public static $shipment_status = array(
		"queue",
		"picked up",
		"on hold",
		"shipping",
		"in transit",
		"cancelled",
		"delivered",
		"returned"
	);
	
	/**
	 * Load all required resource
	 */
	public static function constructor() {
			
		Uss::tag('uri.root', Core::url( ROOT_DIR ));
		
		/** Process Client Panel */
		Events::addListener(
			'udash:ready', 
			\Closure::fromCallable(array('self', 'loadClient' )), 
			EVENT_ID . __CLASS__
		);
		
		/** Process Admin Panel */
		Events::addListener(
			'uadmin:ready', 
			\Closure::fromCallable(array('self', 'loadAdmin')), 
			EVENT_ID . __CLASS__
		);
		
	}
	
	/**
	 * Project Admin Management
	 */
	protected static function loadAdmin() {
		
		Udash::load( UADMIN_ROUTE, function() {
			require_once self::$ADMIN_DIR . "/index.php";
		});
		
		/**
		 * Load Homepage
		 */ 
		require_once self::$HOME_DIR . "/index.php";
		
	}
	
	/**
	 * Project Client Management
	 */
	protected static function loadClient() {
		
		/** Import Database */
		require_once __DIR__ . '/db.php';
		
		self::addRoles();
		self::importCountries();
		self::style();
		self::assignAdmin();
		
		self::$currency = Uss::$global['options']->get('site:currency') ?? 'USD';
		
		if( Uss::query(0) == UDASH_ROUTE ) require self::$CLIENT_DIR . "/index.php";
		
	}
	
	private static function assignAdmin() {
		$superadmin = Roles::get_assigned_users( 'super-admin' );
		if( empty($superadmin) ) {
			$user = Uss::$global['mysqli']->query( SQuery::select( DB_TABLE_PREFIX . "_users" ) )->fetch_assoc();
			if( $user ) {
				$admin = Roles::user( $user['id'] )::assign( 'super-admin' );
			} else {
				Events::addListener('auth:form//signup', function() {
					echo "
						<div class='alert alert-warning'>
							This is the first registering user and by default will be given a role as &mdash; <span class='fw-semibold'>super admin</span>
						</div>
					";
				}, 'Notice');
			}
		};
	}
	
	/**
	 * Add New Roles
	 */
	private static function addRoles() {
		Roles::add('staff', 2, array(
			'view-dashboard',
			'update-profile'
		));
	}
	
	/**
	 * List all countries as a template
	 */
	private static function importCountries() {
		$options = "";
		foreach( Udash::countries() as $key => $value ) {
			$options .= "<option value='{$key}'>{$value}</option>\n";
		};
		Uss::tag('export.countries', $options);
	}
	
	/**
	 * Convert focus path :not(expression) to URL
	 */
	public static function href( $focusPath ) {
		return Core::url( ROOT_DIR . "/{$focusPath}" );
	}
	
	private static function style() {
		Events::addListener('@head:after', function() {
			$src = Core::url( __DIR__ . '/style.css' );
			echo "\t<link rel='stylesheet' href='{$src}'/>\n";
		});
	}	
	
	public static function computePlacement( string $order_no ) {
		
		$data = new stdClass();
		$data->map = [-0.2295, -78.5248];
		
		$id = Uss::$global['mysqli']->real_escape_string( htmlspecialchars($order_no, ENT_QUOTES) );
		
		$data->order = Udash::fetch_assoc( DB_TABLE_PREFIX . "_orders", $id, "order_no" );
		$data->meta = new pairs( Uss::$global['mysqli'], DB_TABLE_PREFIX . "_order_meta" );
		
		if( $data->order ):
		
			$SQL = SQuery::select( DB_TABLE_PREFIX . "_shipments", "order_id = {$data->order['id']}" );
			$data->shipment = Udash::mysqli_to_array( Uss::$global['mysqli']->query( $SQL ) );
			
			if( $data->shipment ):
			
				$last = end($data->shipment);
				
				$latitude = (float)$last['latitude'];
				$longitude = (float)$last['longitude'];

				if( !empty($latitude) && !empty($longitude) ) {
					$data->map[0] = $latitude;
					$data->map[1] = $longitude;
				};
					
			endif;
			
			$SQL = SQuery::select( DB_TABLE_PREFIX . "_packages", "order_id = {$data->order['id']}" );
			$data->packages = Udash::mysqli_to_array( Uss::$global['mysqli']->query( $SQL ) );
			
			$data->office = Udash::fetch_assoc( DB_TABLE_PREFIX . "_offices", $data->order['office_id'] );
			
			$data->staff = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $data->order['staff_id'] );
			
			// PAYMENT SECTION
			
			$prefix = DB_TABLE_PREFIX;
			
			$SQL = "
				SELECT SUM(amount) as `paid`, status
				FROM {$prefix}_payments
				WHERE 
					status IN('pending', 'approved')
					AND order_id = {$data->order['id']}
					GROUP BY order_id, status
			";
			
			$result = Uss::$global['mysqli']->query( $SQL );
			$payment = $result->fetch_assoc() ?? [];
			
			$data->payment = array( 'paid' => (float)( $payment['paid'] ?? 0  ) );
			
			$data->order['price'] = (float)$data->order['price'];
			
			if( ($payment['status'] ?? null) == 'pending' ) $data->payment['status'] = 'confirming';
			else {
				if( $data->payment['paid'] >= $data->order['price'] ) $data->payment['status'] = 'paid';
				else if( !empty($data->payment['paid']) ) $data->payment['status'] = 'paying';
				else $data->payment['status'] = 'unpaid';
			}

			# Set Longitued and latitude

			Uss::tag('map.lat', $data->map[0]);
			Uss::tag('map.lng', $data->map[1]);
		
		else:
		
			$data->shipment = $data->packages = $data->office = null;
		
		endif;
		
		return $data;
		
	}
	
	private static function invoice( $order_no, bool $print = false ) {
		
		$data = self::computePlacement($order_no);
		
		require COURIER_DIR . "/invoice.php";
		
	}
	
	public static function mainOffice() {
		
		$prefix = DB_TABLE_PREFIX;
		
		$SQL = "
			SELECT * FROM {$prefix}_offices
			WHERE status = 1
			ORDER BY _default DESC 
			LIMIT 1
		";
				
		$office = Uss::$global['mysqli']->query( $SQL )->fetch_assoc();
		
		if( $office ) $office['country'] = Udash::countries($office['country']);
		
		return $office;
		
	}
	
	public static function stats( ?int $userid = null ) {
		
		$prefix = DB_TABLE_PREFIX;
		$stats = new stdClass();
		
		$SQL = SQuery::select( "{$prefix}_users" );
		$stats->users = Uss::$global['mysqli']->query( $SQL )->num_rows;
		
		$stats->staffs = count(Roles::get_assigned_users( 'staff' ));
		
		$SQL = SQuery::select( "{$prefix}_offices" );
		$stats->offices = Uss::$global['mysqli']->query( $SQL )->num_rows;
		
		$SQL = SQuery::select( "{$prefix}_gateways" );
		$stats->gateways = Uss::$global['mysqli']->query( $SQL )->num_rows;
		
		if( !$userid ):
		
			$SQL = SQuery::select( "{$prefix}_payments" );
			$stats->payments = Uss::$global['mysqli']->query( $SQL )->num_rows;
		
			$SQL = SQuery::select( "{$prefix}_orders" );
			$stats->shipments = Uss::$global['mysqli']->query( $SQL )->num_rows;
			
		else:
		
			$SQL = "
				SELECT {$prefix}_orders.*
				FROM {$prefix}_orders
				LEFT JOIN {$prefix}_payments
				ON {$prefix}_orders.id = {$prefix}_payments.order_id
			";
			
			$PAYSQL = "
				{$SQL}
				WHERE {$prefix}_orders.sender_id = {$userid}
				GROUP BY {$prefix}_payments.id
			";
			
			$stats->payments = Uss::$global['mysqli']->query( $PAYSQL )->num_rows;
			
			$SHIP_SENT_SQL = "
				{$SQL}
				WHERE {$prefix}_orders.sender_id = {$userid}
				GROUP BY {$prefix}_orders.id
			";
			
			$stats->placements = Uss::$global['mysqli']->query( $SHIP_SENT_SQL )->num_rows;
			
			$SHIP_RECEIVED_SQL = "
				{$SQL}
				WHERE {$prefix}_orders.receiver_id = {$userid}
				GROUP BY {$prefix}_orders.id
			";
			
			$stats->received = Uss::$global['mysqli']->query( $SHIP_RECEIVED_SQL )->num_rows;
			
		endif;
		
		return $stats;
		
	}
	
}
