<?php 
	
defined( 'ROOT_DIR' ) OR DIE; 

$delivery = $data->meta->get('delivery_info', $data->order['id']) ?? [];

?>
<div class='invoice'>

	<div class='container-fluid py-3'>
		
		<div class='row'>
			<div class='col-lg-9 mx-auto'>
				
				<div class='row align-items-center mb-3 unprint'>
					<div class='col-6'>
						<button data-printer='invoice' class='btn btn-primary btn-sm px-4'>
							<i class='bi bi-printer me-1'></i> Print
						</button>
					</div>
					<h4 class='col-6 text-end'>INVOICE</h4>
				</div>
				
				<div class='card rounded-0' data-print='invoice'>
					<div class='card-body'>
						
						<div class='row'>
							<div class='col-3 col-sm-2'>
								<img src='<?php echo Uss::$global['icon']; ?>' class='img-fluid' style='max-height: 50px' >
							</div>
							<div class='col-9 col-sm-6 col-lg-5'>
								<div class='mb-1 d-flex flex-wrap'> 
									<strong class='fw-semibold me-2'>Company: </strong> 
									<div><?php echo Uss::$global['title']; ?></div>
								</div>
								<div class='mb-3'> 
									<strong class='fw-semibold'> Email: </strong> 
									<?php echo Uss::$global['options']->get('email:admin'); ?>
								</div>
							</div>
							<div class='col-9 col-sm-4 col-lg-5'>
								<svg id="barcode" data-word='<?php echo $data->order['order_no']; ?>' class='img-fluid'></svg>
							</div>
						</div>
						
						<hr>
							
						<h4 class='fw-normal text-bg-dark container-fluid py-2 mb-4'>
							Billing
						</h4>
						
						<div class='mb-4 border-bottom border-top py-3'>
							<ul class='list-unstyled fs-14px'>
								<?php
									
									$color = Udash::get_color( $data->payment['status'] );
									
									$currency = Uss::$global['options']->get('site:currency');

									$info = array(
										"Shipping Fee" => $currency . number_format($data->order['price'], 2),
										//"shipment date" => "15th Feb, 2014",
										"paid" => $currency . number_format($data->payment['paid'], 2),
										"status" => "<span class='text-{$color}'>{$data->payment['status']}</span>",
										"invoice #" => $data->order['order_no']
									);
									
									foreach( $info as $key => $value ):
								?>
								<li class='mb-2'>
									<div class='row'>
										<span class='col-6 fw-semibold text-uppercase'><?php echo $key; ?></span>
										<span class='col-6 text-capitalize text-sm-end'><?php echo $value; ?></span>
									</div>
								</li>
								<?php endforeach; ?>
							</ul>
						</div>
							
						<h4 class='fw-normal text-bg-dark container-fluid py-2 mb-4'>
							Dispatch
						</h4>
						
						<div class='row fs-14px'>
						
							<div class='col-sm-6 mb-3'>
								<h5 class='fw-light'>Received:</h5>
								<div class='border p-3'>
									<ul class='list-unstyled'>
									<?php 
										foreach( $data->meta->get('sender_info', $data->order['id']) as $name => $value ):
											if( $name == 'country' ) $value = Udash::countries($value);
									?>
										<li class='text-capitalize mb-2 row'>
											<span class='fw-semibold col-6 col-sm-4'><?php echo $name; ?>:</span> 
											<span class='col-6 col-sm-8'><?php echo $value; ?></span>
										</li>
									<?php endforeach; ?>
									</ul>
								</div>
							</div>
							
							<div class='col-sm-6'>
								<h5 class='fw-light'>To:</h5>
								<div class='border p-3'>
									<ul class='list-unstyled'>
									<?php 
										foreach( $data->meta->get('receiver_info', $data->order['id']) as $name => $value ):
											if( $name == 'country' ) $value = Udash::countries($value);
									?>
										<li class='text-capitalize mb-2 row'>
											<span class='fw-semibold col-6 col-sm-4'><?php echo $name; ?>:</span> 
											<span class='col-6 col-sm-8'><?php echo $value; ?></span>
										</li>
									<?php endforeach; ?>
									</ul>
								</div>
							</div>
						</div>

						<h4 class='fw-normal text-bg-dark container-fluid py-2 mb-4'>
							Delivery
						</h4>

						<div class='row fs-14px'>
						
							<div class='col-sm-6 mb-3'>
								<h5 class='fw-light'>Origin:</h5>
								<div class='border p-3'>
									<ul class='list-unstyled'>
									<?php
										$origin = $delivery['origin'] ?? [];
										foreach( $origin as $name => $value ):
											if( $name == 'country' ) $value = Udash::countries($value);
									?>
										<li class='text-capitalize mb-2 row'>
											<span class='fw-semibold col-6 col-sm-4'><?php echo $name; ?>:</span> 
											<span class='col-6 col-sm-8'><?php echo $value; ?></span>
										</li>
									<?php endforeach; ?>
									</ul>
								</div>
							</div>
							
							<div class='col-sm-6'>
								<h5 class='fw-light'>Destination:</h5>
								<div class='border p-3'>
									<ul class='list-unstyled'>
									<?php 
										$destination = $delivery['destination'] ?? [];
										foreach( $destination as $name => $value ):
											if( $name == 'country' ) $value = Udash::countries($value);
									?>
										<li class='text-capitalize mb-2 row'>
											<span class='fw-semibold col-6 col-sm-4'><?php echo $name; ?>:</span> 
											<span class='col-6 col-sm-8'><?php echo $value; ?></span>
										</li>
									<?php endforeach; ?>
									</ul>
								</div>
							</div>
						</div>
						
						<h4 class='fw-normal text-bg-dark container-fluid py-2 mb-4'>
							Packages
						</h4>
						
						<?php
						
							$table = new class ('package') extends DOMTablet {
								public function complain(){}
							};
							
							$table->data($data->packages);
							
							$table->columns(array(
								"name",
								"weight" => "weight (KG)",
								"quantity"
							));
							
							$table->prepare(null, true);
							
						?>
						
					</div>
				</div>
				
			</div>
		</div>
		
	</div>

</div>

<script src='https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js'></script>
<script>
	window.addEventListener('load', function() {
		
		"use strict";
		
		let word = $('#barcode').attr('data-word');
		JsBarcode( "#barcode", word );
		
		let viewport = $("meta[name='viewport']").get(0);
		let content = viewport.content;
		
		$("[data-printer='invoice']").click(function() {
			viewport.content = "width=1024, user-scalable=no, initial-scale=1.0";
			window.print();
			viewport.content = content;
		});
		
	});
</script>
		