<?php

defined( 'COURIER_DIR' ) OR DIE;

new class($match[1] ?? null) {
	
	private $gateway;
	private $tablename = DB_TABLE_PREFIX . "_gateways";
	
	public  function __construct( $id ) {
		
		Uss::tag('gw.type', 'add');
		
		$this->gateway( $id );
		
		if( $_SERVER['REQUEST_METHOD'] !== 'POST' ) return;
		
		try {
			
			$data = $this->processData($_POST);
			
			$this->gateway ? $this->updateGateway($data) : $this->newGateway($data);
		
		} catch(Exception $e) {
			
			$this->printMsg( $e->getMessage(), false );
			
		}
		
	}
	
	private function processData($data, $sanitize = true ) {
		
		if( $sanitize ) {
			array_walk($data, function(&$value, $key) {
				if( $key == 'detail' ) return;
				$value = Uss::$global['mysqli']->real_escape_string( trim($value) );
			});
		};
		
		$data['detail'] = array_combine( 
			array_map('strtolower', $data['detail']['label']), 
			$data['detail']['value']
		);
		
		$data['detail'] = json_encode($data['detail']);
		
		return $data;
		
	}
	
	private function gateway( $id ) {
		
		$this->gateway = Udash::fetch_assoc( $this->tablename, $id );
		if( !$this->gateway ) return;
		
		$this->loadTemplate( $this->gateway );
		
		Uss::tag('gw.type', 'update');
		
	}
	
	private function uploadIcon() {
		return Udash::uploadFile( "image/jpg|png|gif|jpeg|webp", $_FILES['icon'], "images/gateway" );  
	}
	
	private function newGateway($data) {
		
		$data['icon'] = $this->uploadIcon();
		
		$SQL = SQuery::insert( $this->tablename, $data );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		if( !$result ) throw new \Exception( "The gateway was not added. Please try again" );
		
		$this->printMsg( "The gateway was successfully added", true );
		
	}
	
	private function updateGateway($data) {
		
		// Upload Icon;
		if( empty($_FILES['icon']['error']) ) $data['icon'] = $this->uploadIcon();
		else unset($data['icon']);
		
		$SQL = SQuery::update( $this->tablename, $data, "id = '{$this->gateway['id']}'" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		if( !$result ) throw new Exception( "The gateway data was not updated. Please try again" );
		
		$renew = $this->processData( $_POST, false );
		$renew['icon'] = $data['icon'] ?? $_POST['icon'];
		
		$this->loadTemplate( $renew );
		
		$this->printMsg( "The gateway was successfully updated", true );
		
	}
	
	private function printMsg( string $message, bool $status ) {
		
		$color = $status ? 'success' : 'danger';
		$icon = !$status ? "exclamation-triangle" : "check-circle";
		
		$alert = "<div class='alert alert-{$color}'>
			<i class='bi bi-{$icon} me-1'></i> {$message}
		</div>";
		
		Uss::tag( 'response.message', $alert );
		
	}
	
	private function loadTemplate( array $data ) {
		array_walk($data, function($value, $key) {
			if( !is_scalar($value) ) return;
			if( $key == 'detail' ) $value = base64_encode($value);
			Uss::tag("gateway.{$key}", $value);
		});
		if( !empty($data['icon']) ) Uss::tag( "gateway.iconurl", Core::url( Udash::ASSETS_DIR . "/{$data['icon']}" ) );
	}
	
};
