<?php

/** Create List Menu */

$listFocus = $gatewayFocus . "/list";

$listMenu = $gatewayMenu->add('list', array(
	"label" => "View all",
	"href" => self::href( $listFocus )
));

/** Create View */

Uss::route( $listFocus, function() use($listMenu) {
	
	$listMenu->setAttr('active', true);
	$listMenu->parentMenu->setAttr('active', true);
	
	$tablename = DB_TABLE_PREFIX . "_gateways";
	
	if( Uss::$global['user'] && !empty($_GET['trash']) ) {
		$id = Uss::$global['mysqli']->real_escape_string( $_GET['trash'] );
		$SQL = "DELETE FROM {$tablename} WHERE id = '{$id}'";
		Uss::$global['mysqli']->query( $SQL );
	};
	
	Udash::view(function() use($listMenu, $tablename) {
		
		$table = new DOMTablet( 'gateway' );
		
		$SQL = SQuery::select( $tablename, "1 ORDER BY id DESC" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$table->data( $result );
		
		$table->columns(array(
			"name",
			"model",
			"period",
			"status",
			"action" => ''
		));
		
		$table->wrap();
		
		$table->href = str_replace('/list', null, $listMenu->getAttr('href'));
		
		$table->prepare(function($data) use($table) {
			
			$data['status'] = empty($data['status']) ? "<i class='bi bi-x-octagon text-danger'></i>" : "<i class='bi bi-check-circle text-success'></i>";
			
			$data['action'] = "
				<a href='{$table->href}/new/{$data['id']}' class='btn btn-primary btn-sm'>
					<i class='bi bi-pencil'></i>
				</a>
				<a href='?trash={$data['id']}' data-uss-confirm='Are you sure you want to delete this gateway?' class='btn btn-danger btn-sm'>
					<i class='bi bi-trash'></i>
				</a>
			";
			
			return $data;
			
		}, true);
		
	});
	
}, NULL);