<?php defined( 'COURIER_DIR' ) OR DIE; ?>
<div class='container-fluid'>
	<h3> Manage Gateway </h3>
	<hr>
	<div class=''>
		<form method='POST' enctype='multipart/form-data'>
			
			%{response.message}
			
			<div class='row'>
			
				<div class='col-lg-5 mb-4'>
					
					<div class='mb-3'>
						<label class='form-label --required'>Name</label>
						<input type='text' name='name' value='%{gateway.name}' class='form-control' placeholder='e.g BITCOIN' required>
					</div>
					
					<div class='mb-3'>
						<label class='form-label'>Abbreviation</label>
						<input type='text' name='abbr' value='%{gateway.abbr}' class='form-control' placeholder='e.g BTC'>
					</div>
					
					<div class='mb-3'>
						<label class='form-label --required'>Type</label>
						<select class='form-control' name='model' value='%{gateway.model}'>
							<option value='bank'>Bank</option>
							<option value='crypto'>Crypto</option>
							<option value='third-party'>Third Party</option>
						</select>
					</div>
					
					<div class='mb-3'>
						<label class='form-label --required'>Status</label>
						<select class='form-control' name='status' value='%{gateway.status}'>
							<option value='1'>Enabled</option>
							<option value='0'>Disabled</option>
						</select>
					</div>
					
					<hr/>
					
					<div class='mb-3'>
						<label class='form-label --required'>Icon</label>
						<figure id='icon' class='m-0 mb-2'>
							<img src='%{gateway.iconurl}' class='img-thumbnail' width='120px'>
						</figure>
						<input type='file' name='icon' accept='image/*' data-uss-image-preview='#icon img' class='flatten'>
						<input type='hidden' name='icon' value='%{gateway.icon}'>
						<button class='btn btn-outline-info btn-sm' type='button' data-uss-trigger-click='#icon ~ input'>
							<i class='bi bi-image-alt me-1'></i> Upload Icon
						</button>
					</div>
					
				</div>
				
				<div class='col-lg-7'>
					
					<div class='d-flex justify-content-between border-bottom p-2 mb-3 align-items-center'>
						<p class='display-6'> Gateway Detail </p>
						<button class='btn btn-danger' type='button' id='gw-button'>
							<i class='bi bi-plus-circle'></i>
						</button>
					</div>
					
					<div class='' id='gw-container'></div>
					<input type='hidden' data-gw-encode='%{gateway.detail}'>
					
				</div>
				
			</div>
			
			<hr>
			
			<button class='btn btn-outline-success text-capitalize'>
				%{gw.type} Gateway
			</button>
			
		</form>
	</div>
</div>