"use strict";

$(function() {
	
	new class {
		
		constructor() {
			this.#detailDecode();
			this.#dynamicDetail();
		}
		
		template(label = '', value = '') {
			
			let template = `<div class='mb-3 border-bottom pb-1' data-template>
				<div class='d-flex mb-1 align-items-end'>
					<label class='form-label me-2 fw-light --required text-nowrap'>TITLE</label>
					<input class='form-control bg-light' name='detail[label][]' value='${label}' placeholder='eg:  Wallet Address' required>
				</div>
				<div class='d-flex mb-1'>
					<label class='form-label me-2 fw-light --required text-nowrap'>DATA</label>
					<textarea class='form-control' rows='1' name='detail[value][]' placeholder='eg:  3FZbgi29cpjq2GjdwV8eyHu...' required>${value}</textarea>
				</div>
				<div class='text-end text-sm'>
					<a href='javascript:void(0)' class='text-danger' data-trash>
						<i class='bi bi-trash'></i> Remove
					</a>
				</div>
			</div>`;
			
			return template;
			
		}
		
		#dynamicDetail() {
			
			let instance = this;
			
			$('#gw-button').click(function() {
				instance.#pushTemplate();
			});
			
			$("#gw-container").delegate("[data-trash]", 'click', function() {
				if( $("#gw-container").children().length === 1 ) {
					return toastr.warning( 'Cannot be removed' );
				}
				$(this).parents('[data-template]').remove();
			});
			
			if( !$("#gw-container").children().length ) this.#pushTemplate()
			
		}
		
		#pushTemplate(label = '', value = '') {
			let el = $(this.template(label, value));
			$("#gw-container").append(el);
		}
		
		#detailDecode() {
			let encode = $("[data-gw-encode]").attr('data-gw-encode').trim();
			if( encode == '' ) return;
			let json_data = atob(encode).replace(/(?:\r\n|\r|\n)/ig, "\\n");
			let data = JSON.parse(json_data);
			for(let label in data ) this.#pushTemplate( label, data[label] )
		}
		
	}

});