<?php

defined( 'COURIER_DIR' ) OR DIE;

new class( $match[1] ?? null ) {
	
	public $office;
	public $tablename;
	
	private $errorIcon = "<i class='bi bi-exclamation-triangle me-1'></i>";
	private $successIcon = "<i class='bi bi-check-circle me-1'></i>";
	
	public function __construct( $id ) {
		
		// Save table name
		$this->tablename = DB_TABLE_PREFIX . "_offices";
		
		// get office data;
		$this->office = Udash::fetch_assoc( $this->tablename, $id );
		
		if( $this->office ) {
			$this->loadTemplate( $this->office );
			$this->page( "update", "update" );
		} else {
			$this->page( "new", "add" );
		}
		
		if( $_SERVER['REQUEST_METHOD'] != 'POST' ) return;
		
		$_POST['creator'] = Uss::$global['user']['id'];
		$data = array_map( array(Uss::$global['mysqli'], 'real_escape_string'), $_POST );
		
		$message = ( empty($this->office) ) ? $this->insertOffice( $data ) : $this->updateOffice( $data );
		
		Uss::tag( 'response.message', $message );
		
	}
	
	public function insertOffice( $data ) {

		$SQL = SQuery::insert( $this->tablename, $data );
		
		$status = Uss::$global['mysqli']->query( $SQL );
		
		if( !$status ) {
			
			$message = "<div class='alert alert-danger text-sm'> 
				{$this->errorIcon} The office detail was not added 
			</div>";
			
			$this->loadTemplate( $_POST );
			
		} else $message = "<div class='alert alert-success text-sm'>
			{$this->successIcon} The office detail was successfully added
		</div>";
		
		return $message;
		
	}
	
	public function updateOffice( $data ) {
		
		$SQL = SQuery::update( $this->tablename, $data, "id = '{$this->office['id']}'" );
		
		$status = Uss::$global['mysqli']->query( $SQL );
		
		if( !$status ) {
			
			$message = "<div class='alert alert-danger text-sm'>
				{$this->errorIcon} The office detail was not updated
			</div>";
			
		} else {
			
			$message = "<div class='alert alert-success text-sm'>
				{$this->successIcon} The office detail was successfully updated
			</div>";
			
		};
			
		$this->loadTemplate( $_POST );
		
		return $message;
		
	}
	
	public function loadTemplate( array $var ) {
		/**
		 * Var Template
		 */
		foreach( $var as $key => $value ) {
			Uss::tag( "office.{$key}", $value );
		};
		
		if( !empty($var['_default']) ) Uss::tag('office.main', 'checked');
		
	}
	
	private function page( string $type, string $action ) {
		Uss::tag( "page.type", ucwords($type) );
		Uss::tag( "page.action", ucwords($action) );
	}

};
