<?php 

defined( 'COURIER_DIR' ) OR DIE;

$listMenu = $officeMenu->add('list', array(
	"label" => "View all",
	"href" => self::href( $officeFocus )
));

/** Create View */

Uss::route( $officeFocus, function() use($listMenu) {
	
	$listMenu->setAttr('active', true);
	$listMenu->parentMenu->setAttr('active', true);
	
	/**
	 * Delete Data From Table
	 */
	if( Uss::$global['user'] && isset($_GET['trash']) ) {
		
		$tablename = DB_TABLE_PREFIX . "_offices";
		
		$office = Udash::fetch_assoc( $tablename, $_GET['trash'] );
		
		if( $office ) {
			$SQL = "DELETE FROM {$tablename} WHERE id = '{$office['id']}'";
			Uss::$global['mysqli']->query( $SQL );
		};
		
	};
	
	Udash::view(function() use($listMenu) {
		
		$table = new DOMTablet( "office" );
		
		$table->href = $listMenu->getAttr('href');
		
		$SQL = SQuery::select( DB_TABLE_PREFIX . "_offices", "1 ORDER BY id DESC" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$table->data( $result );
		$table->columns(array(
			"branch",
			"location",
			"contact",
			"status",
			"action"
		));
		
		$table->wrap();
		
		$table->prepare(function($data) use($table) {
			
			$star = empty( $data['_default'] ) ? null : "<i class='bi bi-star me-2 text-warning'></i>";
			
			$data['branch'] = $star . $data['branch'];
			
			$data['contact'] = "
				{$data['email']} <br/>
					{$data['phone']}
			";
			
			$data['location'] = "
				{$data['state']} <br>
			" . Udash::countries( $data['country'] );
			
			$data['status'] = !empty($data['status']) ? "<i class='bi bi-check-circle fs-20px text-success'></i>" : "<i class='bi bi-x-circle fs-20px text-danger'></i>";
			
			$data['action'] = "
				<a href='{$table->href}/new/{$data['id']}' class='btn btn-outline-primary btn-sm'>
					<i class='bi bi-pencil'></i>
				</a>
				<a href='?trash={$data['id']}' data-uss-confirm='Sure you want to delete this office branch? The detail cannot be recovered' class='btn btn-outline-danger btn-sm'>
					<i class='bi bi-trash'></i>
				</a>
			";
			
			return $data;
			
		}, true);
		
	});
	
});
