<?php

defined( 'COURIER_DIR' ) OR DIE;

$editor = new class($match[1]) {

	public $label;
	public $payment;
	public $order;
	
	public function __construct($id) {
		
		$this->label = sha1( "payment-{$id}" );
		
		$this->config( $id );
		
		if( $_SERVER['REQUEST_METHOD'] == 'POST' ) $this->handlePOST($_POST);
		
	}
	
	private function config($id) {
		
		$this->payment = Udash::fetch_assoc( DB_TABLE_PREFIX . "_payments", $id );
		
		if( $this->payment ) {
			
			$this->order = Udash::fetch_assoc( DB_TABLE_PREFIX . "_orders", $this->payment['order_id'] );
			$this->payment['method_detail'] = json_decode( preg_replace("/\n/", "\\n", $this->payment['method_detail']), true);
			
			if( !empty($this->payment['screenshot']) ) {
				$this->payment['screenshot'] = Core::url( MOD_DIR . "/{$this->payment['screenshot']}" );
			}
			
		};
		
	}
	
	private function handlePOST( $data ) {
		
		if( !$this->payment ) return;
		
		$data = array_map([Uss::$global['mysqli'], 'real_escape_string'], $data);
		
		$notify = !empty($data['notify']);
		unset($data['notify']);
		
		$SQL = SQuery::update( DB_TABLE_PREFIX . "_payments", $data, "id = {$this->payment['id']}" );
		$status = Uss::$global['mysqli']->query( $SQL );
		
		$this->msg($status);
		
		if( $notify ) {
			$data['order_no'] = $this->order['order_no'];
			$this->notify( $data, $this->order['sender_id'] );
		};
		
		$this->config( $this->payment['id'] );
		
	}
	
	private function msg($status) {
		
		if( $status ) {
			$icon = "bi bi-check-circle";
			$message = "The payment detail has been updated";
		} else {
			$icon = "bi bi-x-lg";
			$message = "The payment detail could not be updated";
		};
		
		Uss::console('@alert', "
			<div class='d-flex'>
				<span class='me-2'><i class='{$icon}'></i></span>
				<div>{$message}</div>
			</div>
		");
		
	}
	
	private function notify( array $data, int $userid ) {
		
		$message = "Your payment for order #{$data['order_no']} is {$data['status']}\n\n";
		
		if( $data['status'] != 'rejected' ) {
			$message .= "Thank you for choosing " . Uss::$global['title'];
		} else {
			$message .= "Please resend a valid payment or contact the administrator to resolve the issue";
		};
		
		$notification = array(
			"message" => $message,
			"userid" => $userid,
			"model" => "courier",
			"redirect" => $GLOBALS['new-payment-url'] . "/{$data['order_no']}"
		);
		
		Udash::notify( $notification );
		
	}

};