<?php defined( 'COURIER_DIR' ) OR DIE; ?>

<div class='container-fluid'>
	
	<h4 class=''>Manage Payment</h4>
	
	<hr>
	
	<h4 class='fw-light mb-3'><?php echo $editor->order['order_no']; ?></h4>
			
	<div class='row'>
	
		<div class='col-lg-5 mb-4'>
		
			<div class='card mb-4'>
				<div class='card-body'>
					<div class='row'>
						<label class='form-label col-sm-4'>Reference #NO:</label>
						<p class='col-sm-8'><?php echo $editor->payment['payment_ref']; ?></p>
					</div>
					<hr>
					<div class=''>
						<label class='form-label'>Screenshot:</label>
						<?php if( !empty($editor->payment['screenshot'])): ?>
							<a href='<?php echo $editor->payment['screenshot']; ?>' target='<?php echo $editor->label; ?>'>
								<img src='<?php echo $editor->payment['screenshot']; ?>' class='img-fluid'>
							</a>
						<?php else: ?>
							<h3 class='fw-light mb-0 text-center'>No Screenshot</h3>
						<?php endif; ?>
					</div>
				</div>
			</div>
		
			<div class='card'>
				<div class='card-header'>Transaction Gateway</div>
				<div class='card-body table-responsive'>
					<table class='table'>
						<?php
							foreach( $editor->payment['method_detail'] as $label => $value ): 
						?>
						<tr>
							<th><?php echo $label; ?></th>
							<td><?php echo $value; ?></td>
						</tr>
						<?php endforeach; ?>
					</table>
				</div>
			</div>
			
		</div>
		
		<div class='col-lg-7'>
			<div class='card'>
				<div class='card-body p-4 p-sm-5'>
					
					<h3 class='fw-light'>Payment Detail</h3>
					
					<hr>
					
					<form method='POST'>
					
						<div class='mb-3'>
							<label class='form-label'>Amount</label>
							<input type='number' class='form-control' step='0.01' name='amount' value='<?php echo $editor->payment['amount']; ?>'>
						</div>
					
						<div class='mb-3'>
							<label class='form-label'>Transaction ID</label>
							<input type='text' class='form-control' step='0.01' name='payment_ref' value='<?php echo $editor->payment['payment_ref']; ?>'>
						</div>
					
						<div class='mb-3'>
							<label class='form-label'>Payment Status</label>
							<select class='form-select text-capitalize' name='status' value='<?php echo $editor->payment['status']; ?>'>
								<option value='pending'>pending</option>
								<option value='approved'>approved</option>
								<option value='rejected'>rejected</option>
							</select>
						</div>
						
						<hr>
						
						<div class='mb-3'>
							<div class='alert alert-danger text-sm text-center'>
								Notify Client About Payment Status Change
							</div>
							<div class='form-check'>
								<label class='form-check-label'>Notify Client</label>
								<input type='checkbox' class='form-check-input' name='notify'>
							</div>
						</div>
						
						<hr>
						
						<button class='btn btn-primary w-100'>
							Update
						</button>
						
					</form>
					
				</div>
			</div>
		</div>
	
	</div>

</div>