<?php 

defined( 'COURIER_DIR' ) OR DIE;

// Create Payment Menu

$historyMenu = $paymentMenu->add('list', array(
	"label" => "history",
	"href" => self::href( $paymentFocus )
));

// Display Content:

Uss::route( $paymentFocus, function() use($historyMenu, $paymentFocus) {
	
	$historyMenu->setAttr('active', true);
	$historyMenu->parentMenu->setAttr('active', true);
	
	Udash::view(function() use($paymentFocus) {
		
		$paytab = DB_TABLE_PREFIX . "_payments";
		$ordertab = DB_TABLE_PREFIX . "_orders";
		
		if( !empty($_GET['trash']) ) {
			$_GET['trash'] = Uss::$global['mysqli']->real_escape_string($_GET['trash']);
			$SQL = "DELETE FROM {$paytab} WHERE id = '{$_GET['trash']}'";
			Uss::$global['mysqli']->query( $SQL );
		};
		
		if( !empty($_GET['search']) ) {
			$search = Uss::$global['mysqli']->real_escape_string($_GET['search']);
			$WHERE = "
				WHERE CONCAT(
					{$ordertab}.order_no, 
					{$paytab}.status, 
					{$paytab}.payment_ref, 
					{$ordertab}.name
				) LIKE '%{$search}%'
			";
		} else $WHERE = NULL;
		
		$SQL = "
			SELECT 
				{$paytab}.*,
					{$ordertab}.order_no
			FROM {$paytab}
			LEFT JOIN {$ordertab}
			ON {$paytab}.order_id = {$ordertab}.id
				{$WHERE}
			ORDER BY {$paytab}.id DESC
		";
		
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$table = new DOMTablet( 'list' );
		$table->data( $result );
		
		$table->columns(array(
			'order_no' => "Shipment",
			'amount',
			'status',
			'period' => "date",
			'action' => ''
		));
		
		$table->setWidget('search', true);
		
		$table->wrap();
		
		echo "<div class='container-fluid'>";
		
		$table->prepare(function($data) use($paymentFocus) {
			
			$href = Core::url( ROOT_DIR . "/" . self::$adminFocus . "/shipping/new/{$data['order_no']}" );
			$data['order_no'] = "<a href='{$href}'>{$data['order_no']}</a>";
			
			$color = Udash::get_color($data['status']);
			$data['status'] = "<span class='badge bg-{$color}'>{$data['status']}</span>";
			
			
			$search = $_GET['search'] ?? null;
			$edit_url = Core::url( ROOT_DIR . "/{$paymentFocus}/edit/{$data['id']}" );
			
			$data['action'] = "
				<div class='d-flex'>
				
					<a href='{$edit_url}' class='btn btn-outline-primary me-1'>
						<i class='bi bi-pencil'></i>
					</a>
					
					<form data-uss-confirm=''>
						<input type='hidden' name='trash' value='{$data['id']}'>
						<input type='hidden' name='search' value='{$search}'>
						<button class='btn btn-outline-danger'>
							<i class='bi bi-trash'></i>
						</button>
					</form>
					
				</div>
			";
			
			array_walk($data, function(&$value) {
				if( is_numeric($value) ) $value = number_format($value, 2);
				return $value;
			});
			
			return $data;
			
		}, true);
		
		echo "</div>";
		
	});
	
}, NULL);