<?php 

defined( 'COURIER_DIR' ) OR DIE;

/**
 * Focus Menu
 */
$newFocus = $shipmentFocus . "/new";

$newMenu = $shipmentMenu->add('new', array(
	"label" => "add new",
	"href" => self::href( $newFocus ),
	"shipmentFocus" => $shipmentFocus
));


/**
 * Ajax Router
 */
require __DIR__ . "/ajax.php";


/** 
 * Create View 
 */
Uss::route( $newFocus . "(?:/([a-z0-9A-Z\-]+))?", function($match) use($newMenu) {
	
	$newMenu->parentMenu->setAttr('active', true);
	
	if( Uss::$global['user'] ) {
		
		Events::addListener('@body:after', function() {
			$src = Core::url( __DIR__ . "/new.js" );
			echo "\t<script src='{$src}'></script>\n";
		}, get_called_class());
		
		Uss::console( "ajax", Core::url( Udash::AJAX_DIR . "/@ajax.php" ) );
		
		require __DIR__ . "/render.php";
		
	};
	
	Udash::view(function() use($render) {
		require __DIR__ . '/template.php';
	});
	
}, NULL);