<?php

defined( 'COURIER_DIR' ) OR DIE;

$render = new class( get_called_class(), $match[1] ?? '', $newMenu ) {
	
	public $offices = [];
	public $staffs = [];
	
	public $rootClass;
	public $orderMeta;
	
	public $order;
	
	public function __construct( $rootClass, $order_no, $newMenu ) {
		
		$this->rootClass = $rootClass;
		$this->orderMeta = $this->rootClass::$orderMeta;
		$this->newMenu = $newMenu;
		
		try {
	
			$this->offices();
			$this->staffs();
			$this->getOrder( $order_no );
			
			if( $_SERVER['REQUEST_METHOD'] == 'POST' ) $this->POST( $_POST );
			
			if( $this->order ) $this->orderInfo();
			
		} catch( Exception $e ) {
			
			Uss::console('@alert', "<div class='d-flex'>
				<span><i class='bi bi-exclamation-diamond text-danger'></i></span> 
				<div class='flex-grow-1 ms-2'>" . $e->getMessage() . "</div>
			</div>" );
			
			$this->loadTemplate( $_POST );
			
		};
		
		$this->createTrackID();
		
	}
	
	private function offices() {
		$tablename = DB_TABLE_PREFIX . "_offices";
		$SQL = SQuery::select( $tablename, "1 ORDER BY branch" );
		$result = Uss::$global['mysqli']->query( $SQL );
		if( !$result->num_rows ) return;
		while( $office = $result->fetch_assoc() ) {
			$id = $office['id'];
			$name = $office['branch'];
			$this->offices[ $id ] = $name;
		};
	}
	
	private function staffs() {
		foreach( Roles::get_assigned_users( 'staff', true ) as $staff ) {
			$id = $staff['id'];
			$name = $staff['email'];
			$this->staffs[ $id ] = $name;
		}
	}
	
	private function getOrder( string $order_no ) {
		
		if( empty($order_no) ) return;
		
		$this->order = Udash::fetch_assoc( DB_TABLE_PREFIX . "_orders", $order_no, "order_no" );
		
		if( $this->order ) {
			
			$meta = $this->orderMeta->all( $this->order['id'] );
			
			$sender = array( 'email' => $meta['sender_email'] ) + $meta['sender_info'];
			$receiver = array( 'email' => $meta['receiver_email'] ) + $meta['receiver_info'];
			
			$order = array(
				"order" => $this->order,
				"sender" => $sender,
				"receiver" => $receiver,
				"delivery" => $meta['delivery_info'] ?? []
			);
			
			$this->loadTemplate( $order );
			
			Uss::tag( 'ship.req', 'Update' );
			
			$this->newMenu->parentMenu->get('order')->setAttr('active', true);
			
		} else throw new Exception( "
			<span class='text-monospace'>{$order_no}</span> <br/> 
			No shipment with the Track ID was found
		" );
		
	}
	
	public function orderInfo() {
		
		$packageTable = DB_TABLE_PREFIX . "_packages";
		$PACKSQL = "
			SELECT COUNT(id) as packages, SUM(weight) as weight
			FROM {$packageTable}
			WHERE order_id = '{$this->order['id']}'
		";
		$package = Uss::$global['mysqli']->query( $PACKSQL )->fetch_assoc();
		if( !$package ) $package = array( 'weight' => 0, 'packages' => 0 );
		array_walk( $package, function(&$value) {
			$value = round($value,3);
		});
		$package['weight'] .= " KG";
		
		$shipmentTable = DB_TABLE_PREFIX . "_shipments";
		$SHIPSQL = "
			SELECT COUNT(id) AS trackings 
			FROM {$shipmentTable}
			WHERE order_id = '{$this->order['id']}'
		";
		$shipment = Uss::$global['mysqli']->query( $SHIPSQL )->fetch_assoc();
		if( !$shipment ) $shipment = array('trackings' => 0);
		
		$currency = $this->rootClass::$currency;
		
		$this->getOrder( $this->order['order_no'] );
		
		$SQL = SQuery::select( DB_TABLE_PREFIX . "_payments", "order_id = {$this->order['id']}" );
		$payments = Uss::$global['mysqli']->query( $SQL );
		
		$paystate = $payments->num_rows ? "Available" : "NONE";
		$href = Core::url( ROOT_DIR . "/" . $this->rootClass::$adminFocus . "/payments?search={$this->order['order_no']}" );
		
		$data = $package + $shipment + array( 
			'price' => number_format($this->order['price'], 2) . " " . $currency,
			'request status' => $this->order['approval'],
			'order status' => $this->order['status'],
			'payments' => "<a href='{$href}'>{$paystate}</a>"
		);
		
		return $data;
		
	}
	
	public function notice( $object, ?string $trueMsg, ?string $falseMsg ) {
		$status = !empty($object);
		$color = $status ? 'success' : 'danger';
		$message = trim( $status ? $trueMsg : $falseMsg );
		if( empty($message) ) return;
		$alert = "<div class='alert alert-{$color} text-sm text-center p-2'>
			{$message}
		</div>";
		echo $alert;
	}
	
	public function list( ?array $array ) {
		if( empty($array) ) $array = [];
		$array = array('' => "- Select -") + $array;
		$options = '';
		foreach( $array as $value => $text ) $options .= "<option value='{$value}'>{$text}</value>\n";
		echo $options;
	}
	
	private function createTrackID() {
		if( !$this->order ) {
			Uss::tag( 'order.order_no', Core::keygen(8) );
			Uss::tag( 'ship.req', 'Create' );
			$this->newMenu->setAttr('active', true);
		}
	}
	
	private function POST( $data ) {

		foreach( $data as $key => $array ) {
			if( $key != 'order' ) continue;
			if( is_array($array) ) { 
				foreach( $array as $name => $value ) {
					$data[$key][$name] = Uss::$global['mysqli']->real_escape_string( $value );
				}
			};
		};
		
		$order = $data['order'];
		$order['sender_id'] = $this->getUserID( $data['sender']['email'] );
		$order['receiver_id'] = $this->getUserID( $data['receiver']['email'] );
		
		if( empty($order['sender_id']) ) throw new Exception( "The sender does not have a registered account" );
		
		$orderId = !$this->order ? $this->insertOrder( $order ) : $this->updateOrder( $order ); 
		
		$this->createOrderMeta( 'sender', $data['sender'], $orderId );
		$this->createOrderMeta( 'receiver', $data['receiver'], $orderId );
		$this->createOrderMeta( 'delivery', $data['delivery'], $orderId );
		
		if( $this->order ) $this->loadTemplate( $_POST );
		
	}
	
	private function insertOrder( $order ) {
		
		if( empty($order['office_id']) ) unset($order['office_id']);

		$SQL = SQuery::insert( DB_TABLE_PREFIX . "_orders", $order );
		
		$status = Uss::$global['mysqli']->query( $SQL );
		
		if( !$status ) throw new Exception( "The shipment detail was not created. Please try again" );
		
		$orderId = Uss::$global['mysqli']->insert_id;
		
		$shipmentURL = Core::url( ROOT_DIR . "/" . implode("/", Uss::query()) . "/{$order['order_no']}" );
		
		Uss::tag('response.message', "
			<div class='alert alert-success d-flex'>
				<div class='me-2'><i class='bi bi-check-circle me-1'></i></div>
				<div class='flex-grow-1'>
					The shipment detail was successfully created <hr>
					<p>
						<i class='bi bi-truck me-1'></i> 
						<a href='{$shipmentURL}' class='fw-semibold'>View shipment</a> 
					</p>
					<p> 
						<i class='bi bi-arrow-left'></i> 
						<a href='./orders' class='fw-semibold text-danger'> Back to list</a> 
					</p>
				</div>
			</div>
		" );
		
		return $orderId;
		
	}
	
	private function updateOrder( $order ) {
		
		$SQL = SQuery::update( DB_TABLE_PREFIX . "_orders", $order, "id = {$this->order['id']}" );
		$status = Uss::$global['mysqli']->query( $SQL );
		
		if( !$status ) throw new Exception( "The shipment detail was not updated" );
		
		$orderId = $this->order['id'];
		
		Uss::console("@alert", "<i class='bi bi-check-circle me-2'></i> The shipment detail has been updated");
		
		$approval = $_POST['order']['approval'];
		
		if( isset($_POST['notify']) && $approval != 'pending' ) {
			
			$redirect = Core::url( ROOT_DIR . "/" . $this->rootClass::$clientFocus . "/payment/new/{$this->order['order_no']}", true );
			
			if( $approval == 'approved' )
				$message = "Your package shipment has been approved.\n\nPlease proceed to payment or invoice statment";
			else {
				$message = "Your package shipment was declined.";
				$redirect = null;
			}
			
			$notification = array(
				'userid' => $this->order['sender_id'],
				'message' => $message,
				'model' => 'courier',
				'origin' => Uss::$global['user']['id'],
				'redirect' => $redirect
			);
			
			Udash::notify( $notification );
			
		}
		
		return $orderId;
		
	}
	
	private function createOrderMeta( string $client, array $detail, int $orderId = 0 ) {
		$data = array();
		if( isset($detail['email']) ) {
			$data[ "{$client}_email" ] = $detail['email'];
			unset($detail['email']);
		};
		$data[ "{$client}_info" ] = $detail;
		foreach( $data as $key => $value ) {
			$this->orderMeta->set( $key, $value, $orderId );
		};
	}
	
	private function getUserID( string $email ) {
		$user = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $email, 'email' );
		return !$user ? null : $user['id'];
	}
	
	private function loadTemplate( $data ) {
		foreach( $data as $key => $field ) {
			if( is_array($field) ) {
				foreach( $field as $name => $value ) {
					if( is_array($value) ) {
						foreach( $value as $title => $subvalue ) {
							Uss::tag("{$key}.{$name}.{$title}", $subvalue);
						};
					} else {
						Uss::tag( "{$key}.{$name}", $value );
					};
				}
			} else Uss::tag("{$key}", $field);
		}
	}
	
};