<div class="accordion mb-4" id="details">
	<div class="accordion-item">

		<h4 class="accordion-header" id="headingOne">
			<button class="accordion-button fw-bold shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#detailContainer" aria-expanded="true" aria-controls="detailContainer">
				<i class='bi bi-info-circle me-2'></i> Details
			</button>
		</h4>

		<div id="detailContainer" class="accordion-collapse collapse show" data-bs-parent="#details">
			<div class="accordion-body">

				<div class='row'>
					<div class='col-lg-6 mb-1'>
						<div class='card'>
							<div class='card-body'>
								
								<div class='mb-3'>
									<?php $render->notice( $render->offices, null, "Please add an office" ); ?>
									<label class='form-label --required'>Pickup Office</label>
									<select name='order[office_id]' class='form-select' value='%{order.office_id}' required>
										<?php $render->list( $render->offices ); ?>
									</select>
								</div>
								
								<div class='mb-3'>
									<label class='form-label'>Pickup Date</label>
									<input type='datetime-local' name='order[pickup_date]' value='%{order.pickup_date}' class='form-control'>
								</div>
								
								<div class='mb-3'>
									<label class='form-label'>Depature Date</label>
									<input type='datetime-local' name='order[depature_date]' value='%{order.depature_date}' class='form-control'>
								</div>
								
							</div>
						</div>
					</div>
					<div class='col-lg-6 mb-4'>
						<div class='card'>
							<div class='card-body'>
								
								<div class='mb-3'>
									<?php $render->notice( $render->staffs, null, "Please assign staff permission to a user" ); ?>
									<label class='form-label'>Shipment Staff</label>
									<select name='order[staff_id]' class='form-select' value='%{order.staff_id}'>
										<?php $render->list( $render->staffs ); ?>
									</select>
								</div>
								
								<div class='mb-3'>
									<label class='form-label'>Expected Delivery Date</label>
									<input type='datetime-local' name='order[expected_delivery_date]' value='%{order.expected_delivery_date}' class='form-control'>
								</div>
								
								<div class='mb-3'>
									<label class='form-label --required'>Shipment Status</label>
									<select name='order[status]' value='%{order.status}' class='form-select text-capitalize' required>
										<?php 
											$status = (get_called_class())::$shipment_status;
											$status = array_combine($status, $status);
											$render->list( $status ); 
										?>
									</select>
								</div>
								
							</div>
						</div>
					</div>
					
				</div>  <!-- /.rows -->

			</div>
		</div>
	</div>
</div>
