<div class="accordion mb-4" id="reports">
	<div class="accordion-item">

		<h4 class="accordion-header" id="headingOne">
			<button class="accordion-button fw-bold shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#reportContainer" aria-expanded="true" aria-controls="reportContainer">
				<i class='bi bi-info-circle me-2'></i> Reports
			</button>
		</h4>

		<div id="reportContainer" class="accordion-collapse collapse show" data-bs-parent="#reports">
			<div class="accordion-body">

				<div class='row'>
                    
                    <div class='col-lg-12 mb-4'>
						<label class='form-label --required'>Price</label>
						<div class='input-group'>
							<input class='form-control' type='number' step='0.01' placeholder='Shipping Cost' name='order[price]' value='%{order.price}' required>
							<span class='input-group-text'>
								<?php echo (get_called_class())::$currency; ?>
							</span>
						</div>
					</div>
					<div class='col-lg-12 mb-4'>
						<label class='form-label'>Comment</label>
						<textarea class='form-control' rows='4' placeholder='Sender&apos;s Comment' name='order[order_comment]'>%{order.order_comment}</textarea>
					</div>
					<div class='mb-3'>
						<label class='form-label'>Approval Status</label>
						<select class='form-select' name='order[approval]' value='%{order.approval}'>
							<option value='approved'>Approved</option>
							<option value='pending'>Pending</option>
							<option value='declined'>Declined</option>
						</select>
						<div class='mb-3'></div>
						<div class='form-check text-sm'>
							<input type='checkbox' name='notify' class='form-check-input' id='checker'>
							<label class='form-check-label text-info' for='checker'>Notify client about approval change</label>
						</div>
					</div>

				</div> <!-- /.rows -->

			</div>
		</div>
	</div>
</div>