<?php 

defined( 'COURIER_DIR' ) OR DIE; 

Uss::tag( 'detail.row', 'mb-2 row' );
Uss::tag( 'detail.label.class', 'col-sm-3 col-md-2 col-lg-3' );
Uss::tag( 'detail.input.class', 'col-sm-9 col-md-10 col-lg-9' );

$includeTemplate = function( $filename, bool $include = true, $resource = null ) use($render) {
	if( empty($include) ) return;
	require_once __DIR__ . "/template-parts/{$filename}";
}

?>

<div class='container-fluid'>
	
	<form method='POST' enctype='multipart/form-data'>
	
		<?php 

			# Shipment Key
			$includeTemplate( "intro.php" ); 

			# Shipment Overview
			$includeTemplate( "overview.php", !empty($render->order) );

			# Shipment Recipients
			$includeTemplate( "recipients.php" );

			# Shipment Delivery
			$includeTemplate( "delivery.php" );

			# Shipment Details
			$includeTemplate( "details.php" );

			# Shipment Report
			$includeTemplate( "reports.php" );

		?>
		
		<div class=''>
			<button class='btn btn-success btn-lg w-100'>
				%{ship.req} Shipment
			</button>
		</div>
	
	</form>

</div>
