<?php 

defined( 'COURIER_DIR' ) OR DIE;

$packageFocus = $shipmentFocus . '/package';

/**
 * Get Package Page
 */
Uss::route( $packageFocus . "/([a-zA-Z0-9\-]+)", function($match) use($orderMenu) {
	
	$orderMenu->setAttr('active', true);
	$orderMenu->parentMenu->setAttr('active', true);
	
	$tablename = DB_TABLE_PREFIX . "_orders";
	$order = Udash::fetch_assoc( $tablename, $match[1], "order_no" );
	
	if( $order ) {
		
		require __DIR__ . "/manager.php";
		
		Events::addListener('@body:after', function() {
			$src = Core::url( __DIR__ . "/script.js" );
			echo "\t<script src='{$src}' type='module'></script>\n";
		}, get_called_class());
		
	}
	
	Udash::view(function() use($order) {
		
		if( !$order ) return Udash::empty_state("Cannot find any placement associated to the package");
		
		require __DIR__ . '/template.php';
		
	});
	
}, NULL);