<?php

defined('COURIER_DIR') OR DIE;

new class($order, $tablename) {
	
	public $order;
	public $orderTable;
	public $packageTable = DB_TABLE_PREFIX . "_packages";
	
	public function __construct($order, $orderTable) {
		$this->order = $order;
		$this->orderTable = $orderTable;
		$this->loadTemplate( "order", $this->order );
		$this->varieties();
		if( $_SERVER['REQUEST_METHOD'] == 'POST' ) $this->POST( $_POST );
		$this->deletePackage();
	}
	
	public function loadTemplate( $name, $data ) {
		array_walk_recursive( $data, function($value, $key) use($name) {
			Uss::tag("{$name}.{$key}", $value);
		});
	}
	
	public function deletePackage() {
		
		$package = Udash::fetch_assoc( $this->packageTable, $_GET['trash'] ?? null );
		
		if( empty($package) ) return;
		
		$SQL = "DELETE FROM {$this->packageTable} WHERE id = {$package['id']}";
		
		Uss::$global['mysqli']->query( $SQL );
		
		Uss::console( '@alert', "<i class='bi bi-trash3 me-2'></i> Package successfully deleted" );
		
	}
	
	public function varieties() {
		$SQL = SQuery::select( DB_TABLE_PREFIX . "_variants", "1 ORDER BY name" );
		$result = Uss::$global['mysqli']->query( $SQL );
		$option = [];
		while( $var = $result->fetch_assoc() ) $option[] = "<option value='{$var['id']}'>{$var['name']}</option>";
		Uss::tag('list.var', implode($option));
	}
	
	public function POST($data) {
		
		$data['item_no'] = Core::keygen(8);
		$data['order_id'] = $this->order['id'];
		
		$image = Udash::uploadFile( "image/jpg|jpeg|png|webp|gif", $_FILES['image'], __DIR__ . "/images", time() . "-" );

		if( $image ) $data['image'] = $image;

		$this->insertPackage($data);
		
	}
	
	public function insertPackage($data) {
		
		$SQL = SQuery::insert( $this->packageTable, $data, Uss::$global['mysqli']);
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$this->inform( $result, 'added', Uss::$global['mysqli']->error );
		
	}
	
	public function inform($status, $type, $error = null) {
		
		$icon = $status ? "<i class='bi bi-emoji-smile text-success'></i>" : "<i class='bi bi-emoji-frown text-danger'></i>";
		
		if( $status ) $message = "Package was successfully {$type}";
		else $message = "Package was not {$type}";
		
		Uss::console( "@alert", "{$icon} &nbsp; {$message}" );
		
	}
	
};