"use strict";

$(function() {

	new class {
	
		constructor() {
			this.#enablePacker();
			this.#imagePreview();
		}
		
		#enablePacker() {
			$("[data-packer]").click(function() {
				bootbox.dialog({
					message: $("#pack-form").html(),
					onShow: function(e) {
						let container = this;
						$(this).find('button[data-clear]').click(function() {
							$(container).find("[data-uss-image-preview]").val('');
							$(container).find('.pack-img').attr('src', '');
						});
					}
				});
			});
		}

		#imagePreview() {
			$("[data-img-url]:not(:disabled)").click(function() {
				let src = this.dataset.imgUrl;
				let image = `<img src='${src}' class='img-fluid'>`;
				bootbox.dialog({
					message: image
				})
			})
		}
	
	}

});