<?php defined('COURIER_DIR') OR DIE; ?>

<div class='container-fluid'>
	
	<h1 class='mb-3'>Packages</h1>
	
	<div class='mb-3'>
		<input type='text' readonly value='%{order.order_no}' class='form-control form-control-lg'>
	</div>
	
	<div class=''>
		<a class='btn btn-outline-warning me-3' href='%{uri.shipment}/new/%{order.order_no}'>
			<i class='bi bi-arrow-counterclockwise'></i> 
		</a>
		<button href='' class='btn btn-primary' data-packer>
			<i class='bi bi-plus-circle'></i> Add Package
		</button>
	</div>
	
	<hr>
	
	<?php
		
		$SQL = SQuery::select( DB_TABLE_PREFIX . "_packages", "order_id = {$order['id']} ORDER BY name" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$table = new DOMTablet( 'packages' );
		
		$table->columns(array(
			"item_no" => "item ID",
			"name" => "item name",
			"weight",
			"quantity" => "qty",
			"variety",
			"action" => ''
		));
		
		$table->data( $result );
		
		$table->wrap();
		
		$table->prepare(function($data) {
			
			$data['weight'] .= " KG";
			
			$var = Udash::fetch_assoc( DB_TABLE_PREFIX . "_variants", $data['var_id'] );
			$data['variety'] = $var ? $var['name'] : 'NULL';
			
			if( !empty($data['image']) ) {
				$imageURL = Core::url( MOD_DIR . "/{$data['image']}" );
				$disabled = null;
				$paint = "btn-outline-warning";
			} else {
				$imageURL = null;
				$disabled = 'disabled';
				$paint = "btn-outline-secondary cursor-not-allowed";
			};

			$imageBtn = "
				<button class='btn {$paint} {$disabled}' data-img-url='{$imageURL}' {$disabled}>
					<i class='bi bi-image'></i>
				</button>
			";

			$data['action'] = "
				{$imageBtn}
				<a href='?trash={$data['id']}' class='btn btn-danger' data-uss-confirm='Delete this package?'>
					<i class='bi bi-trash'></i>
				</a>
			";
			
			return $data;
			
		}, true);
		
	?>
	
	<div class='d-none' id='pack-form'>
		<div class='p-3 p-sm-4'>
			<form method='POST' enctype='multipart/form-data'>
				<div class='mb-3'>
					<figure class=''>
						<img src='' class='pack-img img-fluid'>
					</figure>
					<div class='input-group'>
						<input type='hidden' name='image' v-bind:value='image'>
						<input type='file' name='image' class='form-control' data-uss-image-preview='.pack-img' accept='jpg,png,jpeg,png,webp'>
						<button class='btn btn-danger' type='button' data-clear title='Clear Image'>
							<i class='bi bi-x-circle'></i>
						</button>
					</div>
				</div>
				<div class='mb-2'>
					<label class='form-label --required'>Item Name</label>
					<input type='text' class='form-control' name='name' v-bind:value="name" required>
				</div>
				<div class='row row-cols-2 mb-2'>
					<div class='mb-2 col'>
						<label class='form-label --required'>Weight in KG</label>
						<input type='number' step='0.001' class='form-control' name='weight' value='1' v-bind:value="weight" required>
					</div>
					<div class='mb-2 col'>
						<label class='form-label --required'>Quantity</label>
						<input type='number' min='1' class='form-control' name='quantity' v-bind:value="quantity" value='1' required>
					</div>
				</div>
				<div class='mb-4'>
					<label class='form-label --required'>Variety</label>
					<select type='number' min='1' class='form-select' name='var_id' v-bind:value="var_id" required>
						%{list.var}
					</select>
				</div>
				<button class='btn btn-success w-100'>
					Add Package
				</button>
			</form>
		</div>
	</div>
	
</div>