<?php 

defined( 'COURIER_DIR' ) OR DIE;

$orderFocus = $shipmentFocus . "/orders";

$orderMenu = $shipmentMenu->add('order', array(
	"label" => "Placements",
	"href" => self::href( $orderFocus )
));

/** Create view */

Uss::route( $orderFocus, function() use($orderMenu) {
	
	$orderMenu->setAttr('active', true);
	$orderMenu->parentMenu->setAttr('active', true);
	
	new class {
		public function __construct() {
			if( empty(Uss::$global['user']) ) return;
			if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
				if( !Uss::nonce( $_POST['ud-bulk']['table'], $_POST['ud-bulk']['nonce'] ) ) {
					return Uss::console('@alert', "Security Check Failed!");
				};
				foreach( $_POST['ud-bulk']['values'] as $id ) {
					$this->delete( (int)$id );
				};
			} else if( !empty($_GET['trash']) ) $this->delete( (int)$_GET['trash'] );
		}
		public function delete( $id ) {
			$SQL = "DELETE FROM " . DB_TABLE_PREFIX . "_orders WHERE id = {$id}";
			Uss::$global['mysqli']->query( $SQL );
		}
	};
	
	Udash::view(function() {
		
		$SQL = SQuery::select( DB_TABLE_PREFIX . "_orders", "1 ORDER BY id DESC" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$table = new DOMTablet('orders');
		
		$table->data( $result );
		
		$table->columns(array(
			"name",
			"order_no" => "Track ID",
			"trackings",
			"depature_date" => "departed",
			"status",
			"approval",
			"price",
			"action" => ''
		));
		
		$table->wrap();
		
		$table->setWidget('bulk', array('delete'), 'id');
		
		$table->prepare(function($data) {
			
			$data['action'] = "
				<a href='./print?order={$data['order_no']}' target='_blank' class='btn btn-secondary'>
					<i class='bi bi-printer'></i>
				</a>
			";

			$href = Core::url( ROOT_DIR . "/tracker?id={$data['order_no']}" );
			
			$data['action'] .= "
				<a href='{$href}' target='_blank' class='btn btn-outline-warning'>
					<i class='bi bi-eye'></i>
				</a>
			";
			
			$data['action'] .= "
				<a href='./new/{$data['order_no']}' class='btn btn-outline-primary'>
					<i class='bi bi-pencil-fill'></i>
				</a>
			";
			
			$data['action'] .= "
				<a href='?trash={$data['id']}' class='btn btn-outline-danger' data-uss-confirm='Are you sure you want to delete this data?'>
					<i class='bi bi-trash3'></i>
				</a>
			";
			
			$data['depature_date'] = (new DateTime($data['depature_date']))->format('Y: dS, M @ h:i A');
			
			$shipmentTable = DB_TABLE_PREFIX . "_shipments";
			
			$result = Uss::$global['mysqli']->query( "
				SELECT COUNT({$shipmentTable}.id) as trackings
				FROM {$shipmentTable}
				WHERE order_id = {$data['id']}
			" )->fetch_assoc();
			
			$data = array_merge( $data, $result ?? array('trackings' => 0) );
			
			$color = Udash::get_color($data['approval']);
			$data['approval'] = "<span class='badge bg-{$color}'>{$data['approval']}</span>";
			
			return $data;
			
		}, true);
		
	});
	
}, null);