<?php 

defined( 'COURIER_DIR' ) OR DIE;

new class($order) {
	
	private $order;
	private $orderMeta;
	private $tablename;
	private $shipment;
	
	public function __construct($order) {
		
		$this->order = $order;
		$this->orderMeta = new Pairs( Uss::$global['mysqli'], DB_TABLE_PREFIX . "_order_meta" );

		$this->tablename = DB_TABLE_PREFIX . "_shipments";
		
		$this->edit();
		
		if( $_SERVER['REQUEST_METHOD'] == 'POST' ) $this->POST( $_POST );
		
	}
	
	private function edit() {
		
		Uss::tag("ship.btn", "Add");
		
		if( empty($_GET['edit']) ) return;
		
		$this->shipment = Udash::fetch_assoc( $this->tablename, $_GET['edit'] );
		if( !$this->shipment ) return;
		
		foreach( $this->shipment as $key => $value ) {
			Uss::tag( "ship.{$key}", $value );
		};
		
		Uss::tag("ship.btn", "Update");
		
	}
	
	private function POST( $data ) {
		
		$data['order_id'] = $this->order['id'];
		
		array_walk($data, function(&$value) {
			$value = Uss::$global['mysqli']->real_escape_string($value);
		});
		
		if( empty($data['id']) ) $this->insertTrack( $data );
		else $this->updateTrack( $data );
		
	}
	
	private function insertTrack($data) {
		
		if( empty($data['id']) ) unset($data['id']);

		try {

			$SQL = SQuery::insert( $this->tablename, $data );
			$result = Uss::$global['mysqli']->query( $SQL );

		} catch(Exception $e) {

			$result = false;

		}
		
		if( $result ) {
			$message = "
				The track data has been added <br> 
				<i class='bi bi-geo-fill me-1'></i> <a href='%{uri.tracker}/%{order.order_no}'>View Trackings</a>
			";
			$this->sendMail( $data );
		} else $message = "Error: The track data was not added";
		
		$this->printMsg( $result, $message );
		
	}
	
	private function updateTrack( $data ) {
		
		$SQL = SQuery::update( $this->tablename, $data, "id = {$this->shipment['id']}" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		if( $result ) {
			$message = "
				The track data has been updated <br> 
				<i class='bi bi-geo-fill me-1'></i> <a href='%{uri.tracker}/%{order.order_no}'>View Trackings</a>
			";
			$this->edit();
			$this->sendMail( $data );
		} else $message = "Error: The track data was not updated";
		
		$this->printMsg( $result, $message );
		
		
	}
	
	private function printMsg( bool $status, $message ) {
		
		$color = $status ? "alert-success" : "alert-danger";
		$icon = !$status ? "<i class='bi bi-x-octagon me-1'></i>" : "<i class='bi bi-check-circle me-1'></i>";
		
		$msg = "<div class='alert {$color} d-flex'>
			<span class='me-2'>{$icon}</span> <div>{$message}</div>
		</div>";
		
		Events::addListener( 'Track.Report', function() use($msg) {
			echo $msg;
		});
		
	}

	protected function sendMail( $data ) {
		
		$sender = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $this->order['sender_id'] );
		$senderInfo = $this->orderMeta->get('sender_info', $this->order['sender_id']);

		$mailTemplate = require Udash::VIEW_DIR . "/MAIL/template.php";
		$bodyTemplate = file_get_contents( __DIR__ . "/mail-template.php" );

		$info = $data + $this->order;

		$info['date'] = date('Y-m-d H:i');
		$info['country'] = Udash::countries( $info['country'] );
		$info['sender_name'] = $senderInfo['name'];
		$info['logo'] = Uss::$global['icon'];
		$info['company_name'] = Uss::$global['title'];

		$bodyTemplate = Core::replace_var($bodyTemplate, $info);

		$mailTemplate = Core::replace_var($mailTemplate, [
			'content' => $bodyTemplate,
			'platform' => $info['company_name']
		]);

		try {

			$PHPMailer = Udash::PHPMailer( true );
			$PHPMailer->addAddress( $sender['email'] );
			$PHPMailer->Subject = "Order Shipment";
			$PHPMailer->Body = $mailTemplate;

			if( $_SERVER['SERVER_NAME'] == 'localhost' ) {
				$PHPMailer->isSMTP();
				$PHPMailer->SMTPAuth = false;
				$PHPMailer->Port = 1025;
				$PHPMailer->Host = 'localhost';
			};

			$PHPMailer->send();

		} catch( Exception $e ) {

			Uss::console('@alert', "<i class='bi bi-exclamation-triangle me-2'></i> Shipment email could not be sent to client <br/> {$e->getMessage()}" );

		};

	}
	
};