<?php

defined( 'COURIER_DIR' ) OR DIE;

/**
 * View Tracking List
 */
Uss::route( $trackerFocus . "/([a-zA-z0-9\-]+)", function($match) use($orderMenu) {
	
	$orderMenu->setAttr('active', true);
	$orderMenu->parentMenu->setAttr('active', true);
	
	$order_no = $match[1] ?? null;
	
	Udash::view(function() use($order_no) {
		
		$order = Udash::fetch_assoc( DB_TABLE_PREFIX . "_orders", $order_no, "order_no" );
		
		if( !$order ) {
			return Udash::empty_state("
				You have provided and incorrect track ID <br>
				Please go back and search for a valid placement
			");
		};
		
		Uss::tag( 'order.order_no', $order['order_no'] );
		
		
		$shipmentTable = DB_TABLE_PREFIX . "_shipments";
		
		/**
		 * Trash Shipment
		 */
		if( isset($_GET['trash']) ) {
			$shipment = Udash::fetch_assoc( $shipmentTable, $_GET['trash'] );
			if( $shipment ) {
				$SQL = "DELETE FROM {$shipmentTable} WHERE id = {$shipment['id']}";
				$result = Uss::$global['mysqli']->query( $SQL );
			};
		}
		
		/**
		 * Get linked shipments
		 */
		$SQL = SQuery::select( $shipmentTable, "order_id = {$order['id']}" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$table = new DOMTablet( 'tracker' );
		
		$table->data( $result );
		
		$table->columns(array(
			'country',
			'state',
			'local_area' => 'area',
			'latitude',
			'longitude',
			'map',
			'action' => '&mdash;'
		));
		
		require __DIR__ . '/template-list.php';
		
	});
	
});
