<?php

defined( 'COURIER_DIR' ) OR DIE;

/**
 * Add new tracking information
 */
Uss::route( $trackerFocus . "/@new/([a-zA-z0-9\-]+)", function($match) use($orderMenu) {
	
	$order = Udash::fetch_assoc( DB_TABLE_PREFIX . "_orders", $match[1] ?? null, "order_no" );
	
	$orderMenu->setAttr('active', true);
	$orderMenu->parentMenu->setAttr('active', true);
	
	if( $order && Uss::$global['user'] ) {
		
		Uss::tag( 'order.order_no', $order['order_no'] );
		
		require __DIR__ . "/POST/@new.php";
		
	};
	
	Udash::view(function() use($order) {
		
		if( !$order ) return Udash::empty_state("Cannot add new tracker to a placement that has not been created");
		
		require __DIR__ . "/template-new.php";
		
	});
	
}, NULL);
