<?php defined( 'COURIER_DIR' ) OR DIE; ?>
<div class='container-fluid'>
	
	<h1 class='mb-3'>History</h1>
	
	<div class='mb-4'>
		<input type='text' value='%{order.order_no}' readonly class='form-control form-control-lg'>
	</div>
	
	<div class='row align-items-center'>
		<div class='col-4 col-sm-6 mb-2'>
			<a href='%{uri.shipment}/new/%{order.order_no}' class=''> 
				<i class='bi bi-arrow-counterclockwise'></i> 
				<span class='d-none d-sm-inline'>Go </span>Back
			</a>
		</div>
		<div class='col-8 col-sm-6 text-end'>
			<a href='%{uri.tracker}/@new/%{order.order_no}' class='btn btn-primary'>
				<i class='bi bi-plus-circle me-1'></i> Add new history
			</a>
		</div>
	</div>
	
	<hr/>
	
	<h2 class='display-5'>Geo Locations</h2>
	
	<div class='card'>
		<div class='card-body'>
			<?php 
				
				$table->prepare(function($data) {
					
					$data['country'] = Udash::countries($data['country']);
					
					$uri = Uss::tag('uri.tracker') . "/@new/" . Uss::tag('order.order_no');
					
					$data['action'] = "
						<a href='{$uri}?edit={$data['id']}' class='btn btn-outline-warning'>
							<i class='bi bi-pen'></i>
						</a>
						<a href='?trash={$data['id']}' class='btn btn-outline-danger' data-uss-confirm='Are you sure you want to delete this track data?'>
							<i class='bi bi-trash3'></i>
						</a>
					";
					
					if( is_numeric($data['latitude']) && is_numeric($data['longitude']) ) {
						$data['map'] = "<i class='bi bi-geo-alt-fill text-primary fs-22px'></i>";
					} else $data['map'] = "<i class='bi bi-x-lg text-danger fs-22px'></i>";
					
					$degree = "&#176;";
					
					$data['latitude'] .= $degree;
					$data['longitude'] .= $degree;
					
					return $data;
				
				}, true);
				
			?>
		</div>
	</div>
	
</div>

