<?php defined( 'COURIER_DIR' ) OR DIE; ?>

<div class='container-fluid'>
	
	<h1 class='mb-3'>History</h1>
	
	<div class='mb-4'>
		<input type='text' value='%{order.order_no}' readonly class='form-control form-control-lg'>
	</div>
	
	<a href='%{uri.tracker}/%{order.order_no}' class=''>
		<i class='bi bi-arrow-counterclockwise'></i> 
		<span class='d-none d-sm-inline'>Go </span>Back
	</a>

	<hr>
	
	<div class='row'>
		<div class='col-md-8 col-lg-7 m-auto'>
		
			<div class='card'>
				<div class='card-body p-md-5 p-sm-4'>
					
					<?php events::exec('Track.Report'); ?>
					
					<form method='POST' enctype='multipart/form-data'>
						
						<div class='mb-3'>
							<label class='form-label'>Country</label>
							<select name='country' class='form-select' value='%{ship.country}'>
								%{export.countries}
							</select>
						</div>
						
						<div class='mb-3'>
							<label class='form-label --required'>State</label>
							<input type='text' name='state' class='form-control' value='%{ship.state}' required>
						</div>
						
						<div class='mb-3'>
							<label class='form-label'>Area</label>
							<p class='text-muted text-sm'>A city, local area or street name</p>
							<textarea name='local_area' class='form-control'>%{ship.local_area}</textarea>
						</div>
						
						<div class='alert alert-info text-sm d-flex'>
							<i class='bi bi-info-circle me-2'></i> 
							<span>Please enter the Decimal Degree (DD) coordinate of the Geographical location to be displayed on map</span>
						</div>
						
						<div class='row mb-3'>
							<div class='col-sm-6 mb-2'>
								<div class='mb-3'>
									<label class='form-label'>Latitude</label>
									<input type='number' step='0.00000001' name='latitude' value='%{ship.latitude}' class='form-control'>
								</div>
							</div>
							<div class='col-sm-6'>
								<div class='mb-3'>
									<label class='form-label'>Longitude</label>
									<input type='number' step='0.00000001' name='longitude' value='%{ship.longitude}' class='form-control'>
								</div>
							</div>
						</div>
						
						<input type='hidden' name='id' value='%{ship.id}'>
						
						<button class='btn btn-success w-100' type='submit'>
							%{ship.btn} Track
						</button>
						
					</form>
					
				</div>
			</div>
	
		</div>
	</div>

</div>