<?php

Events::addListener('uadmin:pages/users/edit.left', function($user) { 

    $userProfile = Uss::$global['usermeta']->get('profile', $user['id']);

    $profile = function($key) use($userProfile) {
        return $userProfile[ $key ] ?? null;
    };

?>
    
    <div class='border rounded-2 p-4 mb-3'>

        <div class='mb-3'>
            <label class='form-label'>Firstname</label>
            <input type='text' name='meta[profile][firstname]' class='form-control' value='<?php echo $profile('firstname'); ?>'>
        </div>

        <div class='mb-3'>
            <label class='form-label'>Lastname</label>
            <input type='text' name='meta[profile][lastname]' class='form-control' value='<?php echo $profile('lastname'); ?>'>
        </div>
        
        <div class='mb-3'>
            <label class='form-label'>Phone</label>
            <input type='number' name='meta[profile][phone]' class='form-control' value='<?php echo $profile('phone'); ?>'>
        </div>

        <div class='mb-3'>
            <label class='form-label'>Country</label>
            <select type='text' name='meta[profile][country]' class='form-select' value='<?php echo $profile('country'); ?>'>
                <?php foreach( Udash::countries() as $key => $value ): ?>
                <option value='<?php echo $key; ?>'><?php echo $value; ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class='mb-3'>
            <label class='form-label'>State</label>
            <input type='text' name='meta[profile][state]' class='form-control' value='<?php echo $profile('state'); ?>'>
        </div>

        <div class='mb-3'>
            <label class='form-label'>Address</label>
            <textarea type='text' name='meta[profile][address]' class='form-control'><?php echo $profile('address'); ?></textarea>
        </div>

    </div>

<?php }, EVENT_ID . "left_10" );