<?php defined('COURIER_DIR') OR DIE; ?>
<div class='container-fluid'>
	
	<div class='alert alert-info text-sm'>
		Variety indicates the category of an item being shipped. For example: <br>
		IPhone, Computer etc are under <strong>Electronic Variety</strong>. <br>
		Fish, Fowl etc are under <strong>Livestock Variety</strong>
	</div>
	
	<hr>
	
	<div class='editor'>
	
		<button class='btn btn-primary' data-var-id='' data-var-name=''>
			<i class='bi bi-tag-fill'></i> Add variety
		</button>
		
		<div class='d-none editor-container'>
			<form method='POST'>
				<input type='hidden' name='id' value='@id'>
				<div class=''>
					<label class='form-label'>Variety Name</label>
					<input type='text' name='name' value='@value' class='form-control form-control-lg' placeholder='%{placeholder}'>
				</div>
			</form>
		</div>
		
	</div>
	
	<div class='my-3'>
		<?php
			
			$SQL = SQuery::select( DB_TABLE_PREFIX . "_variants", "1 ORDER BY id DESC" );
			$result = Uss::$global['mysqli']->query( $SQL );
			
			$table = new DOMTablet( 'variants' );
			$table->data( $result );
			
			$table->columns(array(
				"name",
				"action" => ''
			));
			
			$table->wrap();
			
			echo $table->prepare(function($data) {
				
				$data['name'] = htmlspecialchars( $data['name'], ENT_QUOTES );
				
				$data['action'] = "
					<button class='btn btn-primary btn-sm' data-var-id='{$data['id']}' data-var-name='{$data['name']}'>
						<i class='bi bi-pencil'></i>
					</button>
					<a class='btn btn-danger btn-sm' href='?trash={$data['id']}' data-uss-confirm='Are you sure you want to delete this variety?'>
						<i class='bi bi-trash'></i>
					</a>
				";
				
				return $data;
				
			});
			
		?>
	</div>
	
</div>