<?php 

defined( 'ROOT_DIR' ) OR DIE;

$GLOBALS['shipping-new'] = self::href( self::$adminFocus . "/shipping/new" );

return new class($order) {
	
	public $gateway;
	public $order;
	public $showInvoice;
	
	public function __construct($order) {
		
		try {
			
			$this->order = $order;
			
			$this->getGateways();
			
			if( $_SERVER['REQUEST_METHOD'] == 'POST' && $this->order ) $this->handlePOST( $_POST );
			
			$this->showInvoice();
			
		} catch(Exception $e) {
			return Uss::console( '@alert', $e->getMessage() );
		}
		
	}
	
	private function showInvoice() {
		
		if( !$this->order ) return;
		
		$SQL = SQuery::select( DB_TABLE_PREFIX . "_payments", "
			order_id = '{$this->order['id']}'
			AND status IN('pending', 'approved')
		");
		
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$this->showInvoice = !!$result->num_rows;
		
	}
	
	private function getGateways() {
		
		$id = Uss::$global['mysqli']->real_escape_string($_GET['id'] ?? 0);
		$Main = empty($id) ? null : "AND id = '{$id}'";
		
		$SQL = SQuery::select( DB_TABLE_PREFIX . "_gateways", "status = 1 {$Main} ORDER BY name" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$this->gateway = Udash::mysqli_to_array( $result, function($value, $key) {
			if( $key != 'detail') return $value;
			else {
				$value = preg_replace("/(?:\r\n|\r|\n)/", "\\n", $value);
				$data = json_decode($value, true);
				return $data;
			}
		});
		
	}
	
	private function handlePOST( $data ) {
		
		if( !Uss::nonce( 'bill', $data['nonce'] ?? true ) ) throw new \Exception( "Security check could not be confirmed" );
		
		unset($data['nonce']);
		
		$data['method_detail'] = array_map(function($value) {
			return json_decode(base64_decode($value), true);
		}, $data['method_detail']);
		
		$data['method_detail'] = json_encode( array_combine(
			array_column($data['method_detail'], 'label'), 
			array_column($data['method_detail'], 'value')
		) );
		
		$data['amount'] = $this->order['price'];
		$data['order_id'] = $this->order['id'];
		$data['invoice_key'] = Core::keygen(8);
		
		if( empty($_FILES['screenshot']['error'] ) ) {
			
			$data['screenshot'] = Udash::uploadFile(
				"image/jpg|png|jpeg|webp",
				$_FILES['screenshot'],
				__DIR__ . "/screenshots",
				Uss::$global['user']['id']
			);
			
		};
		
		$SQL = SQuery::insert( DB_TABLE_PREFIX . "_payments", $data );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		if( $result ) {
			
			$message = 'Your payment request is being confirmed';
			
			$this->alertAdmin( $data );
			
		} else $message = 'Sorry! The payment reference could not be submitted';
		
		$this->showInvoice();
		
		throw new \Exception( $message );
		
	}
	
	private function alertAdmin( $data ) {
		
		$message = trim("
			A new payment request just came through for the shipment #{$this->order['order_no']}\n\nPlease confirm the payment and activate shipment.
		");
		
		$admins = Roles::get_assigned_users( 'super-admin' );
		
		foreach( $admins as $userid ) {
			
			$notification = array(
				"userid" => $userid,
				"message" => $message,
				"model" => "courier",
				"redirect" => $GLOBALS['shipping-new'] . "/" . $this->order['order_no']
			);
			
			Udash::notify($notification);
			
		}
		
	}
	
};