<?php defined('COURIER_DIR') OR DIE; ?>

<div class=''>

	<h6 class='display-6 border-bottom pb-3 mb-4'>
		<i>Billing Form</i>
	</h6>
	
	<div class=''>
		
		<h4 class='mb-3'>Payment for shipment #<?php echo $res->order['order_no']; ?></h4>
		
		<div class='table-responsive border rounded-2 px-2 mb-4'>
			<table class='table'>
				<tbody>
					<tr>
						<th>Shipping No:</th> 
						<td><?php echo $res->order['order_no']; ?></td>
					</tr>
					<tr>
						<th>Amount Due:</th> 
						<td><?php echo number_format($res->order['price'], 2) . ' ' . $res->currency; ?></td>
					</tr>
				</tbody>
			</table>
		</div>
		
		<div class='border-top mb-4'></div>
		
		<form method='POST' enctype='multipart/form-data'>
		
			<h5 class='mb-3'>Please make payment to the details displayed below</h5>
			
			<div class='table-responsive border rounded-2 px-2 mb-4'>
				<table class='table'>
					<tbody>
						<?php
							foreach( $res->gateway[0]['detail'] as $label => $value ):
							
								$info = base64_encode( json_encode(array('label' => $label, 'value' => $value)) );
								
						?>
						<tr>
							<th><?php echo $label; ?>:</th> 
							<td>
								<?php echo $value; ?>
								<input type='hidden' name='method_detail[]' value='<?php echo $info; ?>'>
							</td>
						</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>
			
			<div class='border-top mb-4'></div>
			
			<div class='mb-3'>
				<label class='form-label'>Payment Reference No #:</label>
				<input type='text' name='payment_ref' class='form-control' placeholder='Transaction ID' required>
			</div>
			
			<div class='mb-4'>
				<label class='form-label'>Screenshot:</label>
				<input type='file' name='screenshot' accept='.jpg,.png,.jpeg,.webp' class='form-control'>
			</div>
			
			<input type='hidden' name='method_id' value='<?php echo $res->gateway[0]['id']; ?>'>
			<input type='hidden' name='nonce' value='<?php echo Uss::nonce( 'bill' ); ?>'>
			
			<div class='mb-4'>
				<button class='btn btn-primary w-100'>
					Confirm Payment
				</button>
			</div>
			
		</form>
		
	</div>
	
</div>