<?php defined('COURIER_DIR') OR DIE; ?>

<div class='container-fluid'>
	<div class='row mb-5'>
		<div class='col-lg-9 mx-auto'>
		
			<div class='card'>
				<div class='card-body p-4 p-sm-5'>
					
					<?php if( $res->order['approval'] == 'approved' ): ?>
					
						<?php if( count($res->gateway) > 1 ): ?>
						
							<h6 class='display-6 border-bottom pb-3 mb-4'>
								<i>Select Payment Method</i>
							</h6>
							
							<?php 
								foreach( $res->gateway as $gateway ): 
								
									$image = Core::url( Udash::ASSETS_DIR . "/{$gateway['icon']}" );
									
							?>
								<a href='?id=<?php echo $gateway['id']; ?>' class='row border mb-3 rounded-3 p-3 align-items-center text-center text-sm-start'>
									<figure class='mb-2 col-sm-4 col-xxl-2'>
										<img src='<?php echo $image; ?>' class='img-thumbnail'>
									</figure>
									<div class='col-sm-6 col-xxl-2 display-6'>
										<?php echo $gateway['name']; ?>
									</div>
								</a>
							<?php endforeach; ?>
						
						<?php elseif( empty($res->gateway) ): ?>
						
							<div class=''>
								
								<h1 class='display-5'>
									Payment method is not available
								</h1>
								
								<hr>
								
								<h4 class='mb-3'>Please contact the administrator</h4>
								
								<p class='lead'>
									<?php echo "Thank you for choosing " . Uss::$global['title']; ?>
								</p>
								
							</div>
							
						<?php 
							else:
								
								require_once __DIR__ . '/bill-form.php';
								
							endif; 
						?>
					
					<?php else: ?>
					
						<h6 class='display-6'> Payment Section </h6>
						
						<hr>
						
						<h5 class='fw-normal mb-3'><?php echo $res->order['order_no']; ?></h5>
						
						<?php if( in_array( $res->order['approval'], ['rejected', 'declined'] ) ): ?>
							
							<div class=''>
								<span class='fs-30px animate__animated animate__jello'>
									<i class='bi bi-x-octagon text-danger'></i>
								</span> 
								<p class='lead'> Your shipment request was declined </p> 
								<p class='lead'>Please contact the administrator to resolve any issue</p>
								<p class='lead'>Thank you for choosing <?php echo Uss::$global['title']; ?></p>
							</div>
							
						<?php else: ?>
						
							<div class=''>
								<span class='fs-30px animate__animated animate__jello'>
									<i class='bi bi-hourglass-split text-primary'></i>
								</span> 
								<p class='lead'> Your shipment request is being processed </p> 
								<p class='lead'>Payment will be available after approval </p>
							</div>
							
						<?php endif; ?>
					
					<?php endif; ?>
					
				</div>
			</div>
		
		</div>
	</div>
</div>