<?php 

defined( 'COURIER_DIR' ) OR DIE;

$paylistFocus = $paymentFocus . "/history";

$paylistMenu = Uss::$global['menu']->add('paylist', array(
	"label" => "Payment History",
	"icon" => "<i class='bi bi-bank'></i>",
	"href" => self::href( $paylistFocus )
));

$GLOBALS['paynew-focus'] = $paynewFocus;

/**
 *
 */
Uss::route( $paylistFocus, function() {
	
	Udash::view(function() {
		
		$paytab = DB_TABLE_PREFIX . '_payments';
		$ordertab = DB_TABLE_PREFIX . '_orders';
		$userid = Uss::$global['user']['id'];
		
		$SQL = "
			SELECT 
				{$paytab}.*, 
				{$ordertab}.order_no,
				{$ordertab}.price
			FROM {$paytab}
			INNER JOIN {$ordertab}
			ON {$paytab}.order_id = {$ordertab}.id
			WHERE {$ordertab}.sender_id = {$userid}
			ORDER BY {$paytab}.id DESC
		";
		
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$table = new DOMTablet( 'payment' );
		
		$table->data( $result );
		
		$table->columns(array(
			'order_no' => "shipment",
			'price' => "cost",
			'amount' => 'paid',
			'status'
		));
		
		$table->wrap('container-fluid');
		
		echo "<h4 class='display-6 container-fluid mb-3'>Payment History</h4>";
		
		$table->prepare(function($data) {
			
			$color = Udash::get_color( $data['status'] );
			
			$data['status'] = "<span class='badge bg-{$color}'>{$data['status']}</span>";
			
			array_walk($data, function(&$value) {
				if( is_numeric($value) ) $value = number_format($value,2);
			});
			
			$href = Core::url( ROOT_DIR . "/" . $GLOBALS['paynew-focus'] . "/{$data['order_no']}" );
			
			$data['order_no'] = "<a href='{$href}'>{$data['order_no']}</a>";
			
			return $data;
			
		}, true);
		
	});
	
});