<?php 

defined( 'ROOT_DIR' ) OR DIE;

new class( get_called_class(), $shiplistFocus ) {
	
	private $list_href;
	private $rootClass;
	
	public function __construct( $rootClass, $shiplistFocus ) {
		
		try {
			
			$this->rootClass = $rootClass;
			
			$this->list_href = $this->rootClass::href( $shiplistFocus );
			
			if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
				
				$valid = Uss::nonce( 'placement', $_POST['nonce'] ?? null );
				
				if( $valid ) $this->managePOST( $_POST );
				
				Uss::console('@alert', "
					<div class='d-flex'>
						<span class='text-success me-2'>
							<i class='bi bi-check-circle text-success'></i> SUCCESS:
						</span> 
						<p> 
							Your shipment request was successfully sent <br>
							<i class='bi bi-truck'></i> &mdash; <a href='{$this->list_href}'>Click here</a> to view all shipments 
						</p>
					</div>
				" );
				
			};
		
		} catch( Exception $e ) {
			
			Uss::console('@alert', "
				<div class='d-flex'>
					<span class='text-danger me-2'>
						<i class='bi bi-x-lg text-danger fw-semibold'></i> ERROR :
					</span> 
					<p>{$e->getMessage()}</p>
				</div>
			" );
			
			$this->loadTemplate( "receiver", $_POST['receiver_info'], $_POST['receiver_email'] );
			
			Uss::tag( "order.comment", $_POST['order_comment'] ?? null );
			
		}
		
	}
	
	private function managePOST( $data ) {
		
		unset($data['nonce']);
		unset($data['order_comment']);
		
		$data['sender_email'] = Uss::$global['user']['email'];
		$data['sender_info']['name'] = implode(" ", $data['sender_info']['name']);
		$data['receiver_info']['name'] = implode(" ", $data['receiver_info']['name']);
		
		$receiver = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $data['receiver_email'], 'email' );
		
		$order = $this->newOrder( $receiver );
		
		foreach( $data as $key => $value ) {
			$orderMeta = $this->rootClass::$orderMeta;
			$orderMeta->set( $key, $value, $order['id'] );
		};
		
		$this->alert_manager( $order );
		
	}
	
	private function newOrder( $receiver ) {
		
		$order = array(
			"name" => 'Undefined',
			"order_no" => Core::keygen(8),
			"status" => "request",
			"sender_id" => Uss::$global['user']['id'],
			"receiver_id" => $receiver ? $receiver['id'] : null,
			"order_comment" => $_POST['order_comment'] ?? null
		);
		
		$SQL = SQuery::insert( DB_TABLE_PREFIX . "_orders", $order, Uss::$global['mysqli'] );
		
		$status = Uss::$global['mysqli']->query( $SQL );
		
		if( !$status ) throw new Exception( "The request could not be processed" );
		
		$order['id'] = Uss::$global['mysqli']->insert_id;
		
		return $order;
		
	}
	
	private function loadTemplate( string $client, array $data, ?string $email = null ) {
		foreach( $data as $key => $value ) {
			if( $key == 'name' ) {
				Uss::tag("{$client}.firstname", $value[0]);
				Uss::tag("{$client}.lastname", $value[1]);
			} else Uss::tag("{$client}.{$key}", $value);
		};
		Uss::tag("{$client}.email", $email);
	}
	
	private function alert_manager( array $order ) {
		
		$managers = Roles::get_permitted_users( 'manage-users' );
		
		foreach( $managers as $userid ) {
			
			$FocusURI = $this->rootClass::$adminFocus . "/shipping/new/{$order['order_no']}";
			
			$client = Uss::$global['user']['username'] ?: Uss::$global['user']['email'];
			$date = (new DateTime())->format("M dS, M - h:i A");
			
			$notification = array(
				"message" => trim("**{$client}** sent a new shipment request on {$date} \n\n **Order ID**: {$order['order_no']}"),
				"redirect" => Core::url( ROOT_DIR . "/{$FocusURI}", true ),
				"origin" => Uss::$global['user']['id'],
				"model" => "courier",
				"userid" => $userid
			);
			
			Udash::notify( $notification );
			
		};
		
	}

};