<?php

defined( 'COURIER_DIR' ) OR DIE;

$shiplistFocus = $shipmentFocus;

$shiplistMenu = Uss::$global['menu']->add('shiplist', array(
	"label" => 'Shipments',
	"icon" => "<i class='bi bi-truck'></i>",
	"href" => self::href( $shiplistFocus )
));

/**
 *
 */
Uss::route( $shiplistFocus, function() use($shiplistMenu) {
	
	$shiplistMenu->setAttr('active', true);
	
	Udash::view(function() {
		
		$userid = Uss::$global['user']['id'];
		
		$SQL = SQuery::select( DB_TABLE_PREFIX . "_orders", "{$userid} IN(sender_id, receiver_id) ORDER BY id DESC" );
		$result = Uss::$global['mysqli']->query( $SQL );
		
		$table = new DOMTablet('shipments');
		$table->data( $result );
		
		$table->columns(array(
			'order_no' => "Track ID",
			'type',
			'status',
			'approval',
			'pickup_date' => "Picked Up",
			'price',
			'payment',
			'view' => ''
		));
		
		$table->wrap();
		
		$string = $table->prepare(function($data) {
			
			$color = Udash::get_color($data['status']);
			
			$data['status'] = "<span class='badge bg-{$color}'>{$data['status']}</span>";
			
			if( empty($data['pickup_date']) ) $data['pickup_date'] = "Not picked";
			
			if( empty($data['price']) ) {
				$data['price'] = "<i class='bi bi-question-circle fs-18px'></i>";
			} else $data['price'] = number_format($data['price'], 2) . " " . self::$currency;
			
			$href = Core::url( ROOT_DIR . "/tracker?id={$data['order_no']}" );
			
			$data['view'] = "
				<a href='{$href}' target='_blank' class='btn btn-primary'>
					<i class='bi bi-box-arrow-up-right me-1'></i> Track
				</a>
			";
			
			$href = Core::url( ROOT_DIR . "/" . self::$clientFocus . "/payment/new/{$data['order_no']}" );
			
			$data['view'] .= "
				<a href='{$href}' class='btn btn-secondary'>
					<i class='bi bi-currency-pound me-1'></i>
				</a>
			";
			
			if( $data['sender_id'] == Uss::$global['user']['id'] ) {
				$data['type'] = "Sending <br> Package";
			} else {
				$data['type'] = "Receiving <br> Package";
			};
			
			$color = Udash::get_color( $data['approval'] );
			$data['approval'] = "<span class='badge bg-{$color}'>{$data['approval']}</span>";
			
			$compute = self::computePlacement( $data['order_no'] );
			$data['payment'] = ucwords($compute->payment['status']);
			
			return $data;
			
		});
		
		echo "<div class='container-fluid'>{$string}</div>";
		
	});
	
});
