<?php 

defined( 'ROOT_DIR' ) OR DIE; 

$sender = Uss::$global['usermeta']->get('profile', Uss::$global['user']['id']) ?? [];

$profile_href = self::href( UDASH_ROUTE . "/account/profile" );

?>

<div class='container-fluid'>
	
	<?php if( $sender ): ?>
	
	<form method='POST'>
	
		<div class='row'>
			
			<div class='col-lg-4 mb-3'>
				
				<div class='card'>
					<div class='card-body'>
					
						<h4 class='fw-light'>Deliver From</h4>
						
						<ul class=''>
							<?php 
								
								foreach( $sender as $key => $value ):	
									
									$attr = array();
									
									if( in_array($key, ['firstname', 'lastname']) ) {
										$index = "[name][]";
									} else $index = "[$key]";
									
									$attr['name'] = "sender_info{$index}";
									$attr['class'] = ($key == 'country') ? 'form-select' : 'form-control';
									$attr['required'] = '';
									$attr['value'] = $value;
									
									$attr_string = Core::array_to_html_attrs($attr);
									
							?>
							<li class='mb-2'>
								<div class='d-flex'>
								
									<label class='fw-light col-sm-3 col-md-2 col-lg-4 me-2 text-capitalize --required'>
										<?php echo $key; ?>:
									</label>
									
									<?php if( $key == 'address' ): ?>
									
										<textarea <?php echo $attr_string; ?> rows='4'><?php echo $value; ?></textarea>
									
									<?php elseif($key == 'country'): ?>
									
										<select <?php echo $attr_string; ?>>
											%{export.countries}
										</select>
									
									<?php else: ?>
									
										<input <?php echo $attr_string; ?>>
										
									<?php endif; ?>
									
								</div>
							</li>
							<?php endforeach; ?>
						</ul>
						
					</div>
				</div>
				
			</div>
			
			<div class='col-lg-8'>
				<div class='card'>
					<div class='card-body p-4 px-md-5' data-receiver>
							
						<h4 class='fw-light'>Send To</h4>
						
						<hr>
						
						<div class='mb-3'>
							<input type='email' class='form-control' name='receiver_email' value='%{receiver.email}' placeholder='Receiver&apos;s Email' required>
						</div>
						
						<div class='row mb-3'>
							<div class='col-lg-6 mb-2'>
								<label class='form-label --required'>First Name:</label>
								<input type='text' class='form-control' name='receiver_info[name][]' value='%{receiver.firstname}' required>
							</div>
							<div class='col-lg-6'>
								<label class='form-label --required'>Last Name:</label>
								<input type='text' class='form-control' name='receiver_info[name][]' value='%{receiver.lastname}' required>
							</div>
						</div>
						
						<div class='row mb-3'>
							<div class='col-md-4 mb-2'>
								<label class='form-label --required'>Country:</label>
								<select type='text' class='form-select' name='receiver_info[country]' value='%{receiver.country}' required>
									%{export.countries}
								</select>
							</div>
							<div class='col-md-8'>
								<label class='form-label --required'>Phone:</label>
								<input type='number' class='form-control' name='receiver_info[phone]' value='%{receiver.phone}' required>
							</div>
						</div>
						
						<div class='row mb-3'>
							<div class='col-12 mb-2'>
								<label class='form-label --required'>State/City:</label>
								<input type='text' class='form-control' name='receiver_info[state]' value='%{receiver.state}'>
							</div>
							<div class='col-12'>
								<label class='form-label --required'>Address:</label>
								<textarea class='form-control' name='receiver_info[address]' required>%{receiver.address}</textarea>
							</div>
						</div>
						
						<div class='mb-4'>
							<label class='form-label'>Your Comment</label>
							<textarea class='form-control' name='order_comment' rows='6'>%{order.comment}</textarea>
						</div>
						
						<div class=''>
							<button class='btn btn-success w-100'>
								Send Request
							</button>
						</div>
						
					</div>
				</div>
			</div>
			
		</div>
		
		<input type='hidden' name='nonce' value='<?php echo Uss::nonce( 'placement' ); ?>'>
		
	</form>

	<?php else: ?>
	
	<div class='row'>
		<div class='col-lg-8 mx-auto'>
			<div class='card'>
				<div class='card-body p-sm-5'>
					<h4 class='display-5 text-center'>
						Please 
							<a href='<?php echo $profile_href; ?>' class='text-primary'>
								<u>update your profile</u>
							</a> 
						to proceed
					</h4>
				</div>
			</div>
		</div>
	</div>
	
	<?php endif; ?>
	
</div>