<?php

defined( 'ROOT_DIR' ) OR DIE;

new class(get_called_class()) {
	
	public $FocusExp = '(?:home/?)?(?:([a-zA-Z0-9\-]+)(?:\.html)?)?';
	
	public $view_dir = __DIR__ . "/view";
	public $pages_dir = __DIR__ . "/pages";
	public $assets_dir = __DIR__ . "/assets";
	
	private $occupiedPath = [
		UADMIN_ROUTE,
		UDASH_ROUTE
	];
	
	public function __construct( $parent ) {
		$this->rootClass = $parent;
		$this->view();
	}
	
	private function view() {
		
		Uss::route( $this->FocusExp, function($match) {
			
			$this->loadTemplate();
			
			$pathname = $match[1] ?? '';
			
			if( in_array( Uss::query(0), $this->occupiedPath) ) return;
			
			if( empty($pathname) ) $filename = 'index';
			else $filename = $this->cleanFile($pathname);
			
			$file = $this->pages_dir . "/{$filename}.php";
			
			Events::addListener('@head:after', function() {
				// Get the template header scripts
				require $this->view_dir . "/bundle.header.php";
			});
			
			Events::addListener('@body:after', function() {
				// Get the template footer scripts
				require $this->view_dir . "/bundle.footer.php";
			});
			
			Events::addListener('@body:before', function() use($pathname) {
				
				// Get the template header
				require $this->view_dir . "/header.php";
				
				// Get the template hero or breadcrumb
				if( in_array($pathname, ['', 'index'])  ) require $this->view_dir . "/hero.php";
				else require $this->view_dir . "/breadcrumb.php";
				
			});
			
			Events::addListener('@body:beforeAfter', function() {
				// Get the template footer
				require $this->view_dir . "/footer.php";
			});
			
			Uss::view(function() use($file) {
				
				echo "<div id='main'>";
				
				if( is_file($file) ) require_once $file;
				else require_once $this->view_dir . "/404.php";
				
				echo "</div>";
				
			});
			
		});
		
	}
	
	private function cleanFile($pathname) {
		return $pathname;
	}
	
	private function loadTemplate() {
		
		Uss::tag('site.title', Uss::$global['title']);
		
		Uss::tag('dir.img', Core::url( $this->assets_dir . "/img" ));
		
		Uss::tag('url.home', Core::url( ROOT_DIR ));
		Uss::tag('url.admin', Uss::tag('url.home') . "/" . UADMIN_ROUTE );
		Uss::tag('url.dashboard', Uss::tag('url.home') . "/" . UDASH_ROUTE );
		
	}
	
};