<?php 

defined( 'COURIER_DIR' ) OR DIE;

$office = $this->rootClass::mainOffice();

?>    <!-- ======= Contact Section ======= -->
    <section id="contact" class="contact">
      <div class="container" data-aos="fade-up">

        <div class="row gy-4 mt-4">
			
			<?php if( $office ): ?>
			
			  <div class="col-lg-4">

				<div class="info-item d-flex">
				  <i class="bi bi-geo-alt flex-shrink-0"></i>
				  <div>
					<h4>Location:</h4>
					<p><?php echo "{$office['address']}, <br> {$office['state']}, {$office['country']}"; ?></p>
				  </div>
				</div><!-- End Info Item -->

				<div class="info-item d-flex">
				  <i class="bi bi-envelope flex-shrink-0"></i>
				  <div>
					<h4>Email:</h4>
					<p><?php echo $office['email']; ?></p>
				  </div>
				</div><!-- End Info Item -->

				<div class="info-item d-flex">
				  <i class="bi bi-phone flex-shrink-0"></i>
				  <div>
					<h4>Call:</h4>
					<p><?php echo $office['phone']; ?></p>
				  </div>
				</div><!-- End Info Item -->

			  </div>
		  
		  <?php endif; ?>

          <div class="col-lg-8 mx-auto">
            <form action="<?php echo Core::url( $this->rootClass::$HOME_DIR . "/forms/contact.php" ); ?>" method="post" role="form" class="php-email-form">
              <div class="row">
                <div class="col-md-6 form-group">
                  <input type="text" name="name" class="form-control" id="name" placeholder="Your Name" required>
                </div>
                <div class="col-md-6 form-group mt-3 mt-md-0">
                  <input type="email" class="form-control" name="email" id="email" placeholder="Your Email" required>
                </div>
              </div>
              <div class="form-group mt-3">
                <input type="text" class="form-control" name="subject" id="subject" placeholder="Subject" required>
              </div>
              <div class="form-group mt-3">
                <textarea class="form-control" name="message" rows="5" placeholder="Message" required></textarea>
              </div>
			  <input type='hidden' name='bash' value='<?php echo base64_encode(Uss::$global['options']->get('email:admin')); ?>'>
              <div class="my-3">
                <div class="loading">Loading</div>
                <div class="error-message"></div>
                <div class="sent-message">Your message has been sent. Thank you!</div>
              </div>
              <div class="text-center"><button type="submit">Send Message</button></div>
            </form>
          </div><!-- End Contact Form -->

        </div>

      </div>
    </section><!-- End Contact Section -->
