<?php

defined('ROOT_DIR') OR DIE;

$tracker = new class($this) {
	
	public $order;
	public $meta;
	public $shipment;
	public $packages;
	public $office;
	public $map;
	public $delivery;
	
	private $parent;
	
	public function __construct($parent) {
		
		$this->parent = $parent;
		
		$this->findOrder( $_GET['id'] ?? '' );
		
	}
	
	private function findOrder( $orderNo ) {
		
		$data = $this->parent->rootClass::computePlacement( $orderNo );
		
		foreach( $data as $key => $value ) $this->{$key} = $value;

		if( $this->order ) {
			$this->delivery = $this->meta->get('delivery_info', $this->order['id'] );
		};
		
	}
	
	public function show(string $key) { 
	
		$client = $this->meta->get("{$key}_info", $this->order['id']);
		$client['country'] = Udash::countries( $client['country'] );
		
		$change = array(
			// key => [ label, icon ]
			"name" => ['Contact Name', 'person-circle'],
			"phone" => ['Phone Number', 'telephone'],
			"address" => ['Contact Address', 'house-check'],
			"state" => ['Origin City', 'geo-alt-fill'],
			"country" => ['Country', 'geo']
		);
		
		foreach( $change as $key => $data ):
	?>
		<div class='d-flex'>
			<div class='icon me-3'>
				<i class='bi bi-<?php echo $data[1]; ?> fs-26px'></i> 
			</div>
			<div class=''>
				<label class='text-muted'><?php echo $data[0]; ?></label>
				<p><?php echo $client[$key]; ?></p>
			</div>
		</div>
	<?php 
		endforeach;
	}
	
	public function expose(string $title, string $icon, ?string $content) {
		if( empty($content) ) $content = '&mdash;';
	?>
		<div class='mb-2 border-bottom py-3'>
			<h5 class='mb-3'>
				<i class='bi bi-<?php echo $icon; ?> me-2'></i>
				<label class=''><?php echo $title; ?></label>
			</h5>
			<div class='ps-4'><?php echo $content; ?></div>
		</div>
	<?php }
	
	public function history() {
		
		$table = new DOMTablet('shipment');
		
		$table->data( $this->shipment );
		
		$columns = array(
			"country",
			"state",
			"local_area"
		);
		
		$columns = array_combine( $columns, array_map('ucwords', $columns ) );
		
		$columns['local_area'] = 'Area';
		
		$table->columns($columns);
		
		$table->prepare(function($data) {
			$data['country'] = Udash::countries($data['country']);
			return $data;
		}, true);
		
	}

	public function listPackages() {

		$table = new DOMTablet("packages");

		$table->data( $this->packages );
		
		$table->columns(array(
			"item_no" => "#",
			"image" => '',
			"name",
			"weight",
			"quantity"
		));

		$table->prepare(function($data) {
			$data['weight'] .= " KG";
			if( !empty($data['image']) ) {
				$image = Core::url( MOD_DIR . "/" . $data['image']);
				$data['image'] = "
					<a href='{$image}' class='glightbox'>
						<img src='{$image}' class='img-fluid img-thumbnail' width='80px'>
					</a>";
			};
			return $data;
		}, true);

	}
	
};

/* -------------------------------------------------------------------------------
// END TRACKER CLASS
---------------------------------------------------------------------------------*/

?>
<section class='container track-section'>
	
	<div class='mb-5'>
		<form action="%{url.home}/tracker" class="form-search mb-3">
			<p class='text-muted'>
				<i class='bi bi-info-circle me-1'></i> Please enter your track ID
			</p>
			<div class='track-input'>
				<div class='input-group'>
					<input type="text" name="id" class="form-control form-control-lg" placeholder="Track ID" value='<?php echo $_GET['id'] ?? null; ?>' required="">
					<button type="submit" class="btn btn-primary">
						Search
					</button>
				</div>
			</div>
		</form>
	</div>
	
	<h1 class='display-6'>YOUR TRACK DETAIL</h1>
	
	<hr>
	
	<div class='my-5'>
	
	<?php if( empty($tracker->order) ): ?>
	
		<div class='text-center text-uppercase'>
		
			<h1 class='display-4'> 
				No order placed 
			</h1>
			
			<img src='%{dir.img}/shipping.png' class='img-fluid' width='440px'>
			
		</div>
		
	<?php else: ?>
		
		<div data-printable>
			
			<?php 
				if( $tracker->staff ) {
					call_user_func(function() use($tracker) {
						$profile = Uss::$global['usermeta']->get('profile', $tracker->staff['id']);
						if( !$profile ) return;
			?>
				<div class='row mb-5'>
					<div class='col-lg-12'>
						<div class='d-flex flex-wrap text-center text-sm-start align-items-center'>
							<figure class='mb-3 me-sm-3 mx-auto mx-sm-start'>
								<img src='https://png.pngtree.com/png-clipart/20211026/original/pngtree-cartoon-delivery-man-png-image_876933.png' height='120px' class=''>
							</figure>
							<div class='flex-grow-1'>
								<h4 class='fw-light mb-3'>
									<u>Contact Person</u>
								</h4>
								<div class='mb-1'>
									<i class='bi bi-person-workspace me-1'></i>
									<?php echo "{$profile['firstname']} {$profile['lastname']}"; ?>
								</div>
								<div>
									<i class='bi bi-telephone me-1'></i>
									<?php echo "{$profile['phone']}"; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php 
					});
				}; 
			?>

			<div class='row mb-4'>
				
				<div class='col-lg-6'>
					<div class='card mb-4'>
						<h4 class='card-header fw-normal'>
							<i class='bi bi-info-circle'></i> Sender Info
						</h4>
						<div class='card-body'>
							<?php $tracker->show('sender'); ?>
						</div>
					</div>
				</div>
				
				<div class='col-lg-6'>
					<div class='card rounded-0'>
						<h4 class='card-header fw-normal'>
							<i class='bi bi-info-circle'></i> Receiver Info
						</h4>
						<div class='card-body'>
							<?php $tracker->show('receiver'); ?>
						</div>
					</div>
				</div>
				
			</div>
			
			<div class='row '>
				
				<div class='col-lg-12 mb-4'>
				
					<div class='card rounded-0'>
					
						<h4 class='text-bg-dark p-2 m-2 text-center'>
							Shipment Detail
						</h4>
						
						<div class='p-3'>
							<div class='row'>
								<div class='col-md-6'>
									<?php
										
										$tracker->expose( 
											"Track ID", 
											"compass",
											$tracker->order['order_no']
										);
										
										$tracker->expose( 
											"Status", 
											"patch-question",
											ucwords($tracker->order['status'])
										);

										$tracker->expose(
											"Origin",
											"house-up",
											call_user_func(function() use($tracker) {
												if( empty($tracker->delivery) ) return;
												$source = $tracker->delivery['origin'];
												return "<p>{$source['address']} <br/> {$source['city']}, {$source['country']}</p>";
											})
										);
										
										$tracker->expose( 
											"Dispatch Office", 
											"building-check",
											call_user_func(function() use($tracker) {
												if( !$tracker->office ) return "Unknown";
												return "<p>{$tracker->office['branch']} <br/> {$tracker->office['address']}</p>";
											})
										);
										
									?>
								</div>
								<div class='col-md-6'>
									<?php 
									
										$tracker->expose(
											"Pickup Date",
											"clock-history",
											call_user_func(function() use($tracker) {
												if( empty($tracker->order['pickup_date']) ) return 'Not Picked';
												return (new DateTime($tracker->order['pickup_date']))->format("Y M d H:i");
											})
										);
									
										$tracker->expose(
											"Dispatch Date",
											"rocket-takeoff",
											call_user_func(function() use($tracker) {
												if( empty($tracker->order['depature_date']) ) return 'NULL';
												return (new DateTime($tracker->order['depature_date']))->format("Y M d H:i");
											})
										);
									
										
										$tracker->expose(
											"Destination",
											"house-down",
											call_user_func(function() use($tracker) {
												if( empty($tracker->delivery) ) return;
												$source = $tracker->delivery['destination'];
												return "<p>{$source['address']} <br/> {$source['city']}, {$source['country']}</p>";
											})
										);

										$tracker->expose(
											"Expected Delivery Date",
											"box",
											call_user_func(function() use($tracker) {
												if( empty($tracker->order['expected_delivery_date']) ) return 'NULL';
												return (new DateTime($tracker->order['expected_delivery_date']))->format("Y M d");
											})
										);
										
									?>
								</div>
							</div>
						</div>
						
					</div>
					
				</div>
				
			</div>
			
			<?php if( !empty($tracker->shipment) ): ?>
			
				<div class='card mb-4'>
					<div class='card-body'>
					
						<h4 class='text-bg-dark p-2 mb-3 text-center'>History</h4>
						
						<div class='row'>
						
							<div class='col-lg-5'>
								<div class='border mb-3'>
									<div id='map' style='height:400px;'></div>
								</div>
							</div>
							
							<div class='col-lg-7'>
								<div class='border p-2 fs-14px'>
									<?php $tracker->history(); ?>
								</div>
							</div>
						
						</div>
					
					</div>
				</div>
			
			<?php endif; ?>
			
			<?php //if( !empty($tracker->packages) ): ?>
			
			<div class='card'>
				<div class='card-body'>
				
					<h4 class='text-bg-dark p-2 mb-3 text-center'>Packages</h4>
					
					<div class='row'>

						<div class='col-lg-12'>
							<div class='border p-2 fs-14px'>
								<?php $tracker->listPackages(); ?>
							</div>
						</div>
					
					</div>
				
				</div>
			</div>
		
		<?php //endif; ?>
		
		</div>
		
	<?php endif; ?>
	
	</div>
	
</section>